/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.cache;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.cache.IListRecipe;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class CachedRecipeList<R extends Recipe<?>> {
    public static final int INVALID_RELOAD_COUNT = -1;
    private static int reloadCount = 0;
    private final Supplier<RecipeType<R>> type;
    private final Class<R> recipeClass;
    private Map<ResourceLocation, R> recipes;
    private List<RecipeHolder<R>> recipeHolders;
    private boolean cachedDataIsClient;
    private int cachedAtReloadCount = -1;

    public CachedRecipeList(Supplier<RecipeType<R>> type, Class<R> recipeClass) {
        this.type = type;
        this.recipeClass = recipeClass;
    }

    public CachedRecipeList(IERecipeTypes.TypeWithClass<R> type) {
        this((Supplier<RecipeType<R>>)type.type(), type.recipeClass());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onTagsUpdated(TagsUpdatedEvent ev) {
        ++reloadCount;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRecipeUpdatedClient(RecipesUpdatedEvent ev) {
        ++reloadCount;
    }

    public static int getReloadCount() {
        return reloadCount;
    }

    public List<RecipeHolder<R>> getRecipes(@Nonnull Level level) {
        this.updateCache(level.getRecipeManager(), level.isClientSide());
        return Objects.requireNonNull(this.recipeHolders);
    }

    public Collection<ResourceLocation> getRecipeNames(@Nonnull Level level) {
        this.updateCache(level.getRecipeManager(), level.isClientSide());
        return Objects.requireNonNull(this.recipes).keySet();
    }

    public R getById(@Nonnull Level level, ResourceLocation name) {
        this.updateCache(level.getRecipeManager(), level.isClientSide());
        return (R)((Recipe)this.recipes.get(name));
    }

    private void updateCache(RecipeManager manager, boolean isClient) {
        if (this.recipes != null && this.cachedAtReloadCount == reloadCount && (!this.cachedDataIsClient || isClient)) {
            return;
        }
        this.recipes = manager.getRecipes().stream().filter(iRecipe -> iRecipe.value().getType() == this.type.get()).flatMap(r -> {
            Recipe patt3189$temp = r.value();
            if (patt3189$temp instanceof IListRecipe) {
                IListRecipe listRecipe = (IListRecipe)patt3189$temp;
                return Streams.mapWithIndex(listRecipe.getSubRecipes().stream(), (subRecipe, i) -> new RecipeHolder(r.id().withSuffix(Long.toString(i)), (Recipe)subRecipe));
            }
            return Stream.of(r);
        }).collect(Collectors.toMap(RecipeHolder::id, rh -> (Recipe)this.recipeClass.cast(rh.value())));
        this.recipeHolders = this.recipes.entrySet().stream().map(e -> new RecipeHolder((ResourceLocation)e.getKey(), (Recipe)e.getValue())).toList();
        this.cachedDataIsClient = isClient;
        this.cachedAtReloadCount = reloadCount;
    }
}

