/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ThermoelectricSource
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<ThermoelectricSource>> SERIALIZER;
    public static final CachedRecipeList<ThermoelectricSource> ALL_SOURCES;
    public final FastEither<TagKey<Block>, List<Block>> blocks;
    public final int temperature;

    public ThermoelectricSource(TagKey<Block> blocks, int temperature) {
        this(FastEither.left(blocks), temperature);
    }

    public ThermoelectricSource(List<Block> blocks, int temperature) {
        this(FastEither.right(blocks), temperature);
    }

    public ThermoelectricSource(Block block, int temperature) {
        this(List.of(block), temperature);
    }

    private ThermoelectricSource(FastEither<TagKey<Block>, List<Block>> blocks, int temperature) {
        super(TagOutput.EMPTY, IERecipeTypes.THERMOELECTRIC_SOURCE);
        this.blocks = blocks;
        this.temperature = temperature;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public Block getExample() {
        return this.blocks.map(tagKey -> BuiltInRegistries.BLOCK.getTag(tagKey).flatMap(t -> t.getRandomElement(ApiUtils.RANDOM_SOURCE)).map(Holder::value).orElse(Blocks.AIR), l -> l.isEmpty() ? Blocks.AIR : (Block)l.get(0));
    }

    public List<Block> getMatchingBlocks() {
        return this.blocks.map(t -> TagUtils.elementStream(BuiltInRegistries.BLOCK, t).toList(), Function.identity());
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean matches(Block block) {
        if (this.blocks.isLeft()) {
            return block.defaultBlockState().is(this.blocks.leftNonnull());
        }
        return this.blocks.rightNonnull().contains(block);
    }

    @Nullable
    public static ThermoelectricSource getSource(Level level, Block block, @Nullable ThermoelectricSource hint) {
        if (hint != null && hint.matches(block)) {
            return hint;
        }
        for (RecipeHolder<ThermoelectricSource> entry : ALL_SOURCES.getRecipes(level)) {
            if (!((ThermoelectricSource)entry.value()).matches(block)) continue;
            return (ThermoelectricSource)entry.value();
        }
        return null;
    }

    public static SortedMap<Component, Integer> getThermalValuesSorted(Level level, boolean inverse) {
        Fluid[] fluidsToShow;
        TreeMap<Component, Integer> existingMap = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, inverse ? Comparator.reverseOrder() : Comparator.naturalOrder()));
        for (RecipeHolder<ThermoelectricSource> ingr : ALL_SOURCES.getRecipes(level)) {
            Block example = ((ThermoelectricSource)ingr.value()).getExample();
            if (example == Blocks.AIR) continue;
            existingMap.put(new ItemStack((ItemLike)example).getHoverName(), ((ThermoelectricSource)ingr.value()).temperature);
        }
        for (Fluid f : fluidsToShow = new Fluid[]{Fluids.WATER, Fluids.LAVA}) {
            FluidStack fs = new FluidStack(f, 1000);
            existingMap.put(fs.getDisplayName(), f.getFluidType().getTemperature(fs));
        }
        return existingMap;
    }

    static {
        ALL_SOURCES = new CachedRecipeList<ThermoelectricSource>(IERecipeTypes.THERMOELECTRIC_SOURCE);
    }
}

