/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.FastEither;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.registries.DeferredHolder;

public class WindmillBiome
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<WindmillBiome>> SERIALIZER;
    public static final CachedRecipeList<WindmillBiome> ALL_BIOMES;
    public final FastEither<TagKey<Biome>, List<ResourceKey<Biome>>> biomes;
    public final float modifier;

    public WindmillBiome(TagKey<Biome> biomes, float modifier) {
        this(FastEither.left(biomes), modifier);
    }

    public WindmillBiome(List<ResourceKey<Biome>> biomes, float modifier) {
        this(FastEither.right(biomes), modifier);
    }

    private WindmillBiome(FastEither<TagKey<Biome>, List<ResourceKey<Biome>>> biomes, float modifier) {
        super(TagOutput.EMPTY, IERecipeTypes.WINDMILL_BIOME);
        this.biomes = biomes;
        this.modifier = modifier;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public float getModifier() {
        return this.modifier;
    }

    public boolean matches(Holder<Biome> biome) {
        if (this.biomes.isLeft()) {
            return biome.is(this.biomes.leftNonnull());
        }
        return this.biomes.rightNonnull().stream().anyMatch(arg_0 -> biome.is(arg_0));
    }

    @Nullable
    public static WindmillBiome getBiome(Level level, Holder<Biome> biome, @Nullable WindmillBiome hint) {
        if (hint != null && hint.matches(biome)) {
            return hint;
        }
        for (RecipeHolder<WindmillBiome> entry : ALL_BIOMES.getRecipes(level)) {
            if (!((WindmillBiome)entry.value()).matches(biome)) continue;
            return (WindmillBiome)entry.value();
        }
        return null;
    }

    static {
        ALL_BIOMES = new CachedRecipeList<WindmillBiome>(IERecipeTypes.WINDMILL_BIOME);
    }
}

