/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MultiblockAdvancementTrigger
implements CriterionTrigger<Instance> {
    public static final DeferredRegister<CriterionTrigger<?>> REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"immersiveengineering");
    public static Supplier<MultiblockAdvancementTrigger> INSTANCE = REGISTER.register("multiblock_formed", MultiblockAdvancementTrigger::new);
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public void addPlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, listeners);
        }
        listeners.add(listener);
    }

    public void removePlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void removePlayerListeners(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
        Listeners listeners = this.listeners.get(player.getAdvancements());
        if (listeners != null) {
            listeners.trigger(multiblock, hammer);
        }
    }

    public static Criterion<?> create(ResourceLocation multiblock, ItemPredicate hammer) {
        return INSTANCE.get().createCriterion(new Instance(multiblock, hammer));
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
            List list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.trigger()).test(multiblock, hammer)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener1 : list) {
                    listener1.run(this.playerAdvancements);
                }
            }
        }
    }

    public record Instance(ResourceLocation multiblock, ItemPredicate hammer) implements CriterionTriggerInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("multiblock").forGetter(Instance::multiblock), (App)ItemPredicate.CODEC.fieldOf("hammer").forGetter(Instance::hammer)).apply((Applicative)inst, Instance::new));

        public boolean test(MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
            return this.multiblock.equals((Object)multiblock.getUniqueName()) && this.hammer.matches(hammer);
        }

        public void validate(CriterionValidator validator) {
        }
    }
}

