/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.registry;

import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MultiblockBlockEntityMaster<State extends IMultiblockState>
extends BlockEntity
implements IModelOffsetProvider,
IMultiblockBE<State> {
    private final IMultiblockBEHelperMaster<State> helper;

    public MultiblockBlockEntityMaster(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState, MultiblockRegistration<State> multiblock) {
        super(type, worldPosition, blockState);
        this.helper = IMultiblockBEHelperMaster.MAKE_HELPER.get().makeFor(this, multiblock);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.helper.load(tag);
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.helper.saveAdditional(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return this.helper.getUpdatePacket();
    }

    @Nonnull
    public CompoundTag getUpdateTag() {
        return this.helper.getUpdateTag();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.helper.handleUpdateTag(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.helper.onDataPacket(pkt.getTag());
    }

    @Override
    public IMultiblockBEHelperMaster<State> getHelper() {
        return this.helper;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @javax.annotation.Nullable Vec3i size) {
        return BlockPos.ZERO;
    }

    public void setRemoved() {
        super.setRemoved();
        this.helper.invalidateAllCaps();
    }

    public void onLoad() {
        super.onLoad();
        this.helper.invalidateAllCaps();
    }
}

