/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.registry;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultiblockPartBlock<State extends IMultiblockState>
extends Block
implements EntityBlock {
    private final MultiblockRegistration<State> multiblock;
    private final boolean needsServerTicker;
    private final boolean needsClientTicker;

    public MultiblockPartBlock(BlockBehaviour.Properties properties, MultiblockRegistration<State> multiblock) {
        super(properties.dynamicShape());
        this.multiblock = multiblock;
        boolean hasMirrorProperty = this.getStateDefinition().getProperties().contains(IEProperties.MIRRORED);
        Preconditions.checkState((this.multiblock.mirrorable() == hasMirrorProperty ? 1 : 0) != 0);
        this.needsServerTicker = multiblock.logic() instanceof IServerTickableComponent ? true : multiblock.extraComponents().stream().map(MultiblockRegistration.ExtraComponent::component).anyMatch(c -> c instanceof IServerTickableComponent);
        this.needsClientTicker = multiblock.logic() instanceof IClientTickableComponent ? true : multiblock.extraComponents().stream().map(MultiblockRegistration.ExtraComponent::component).anyMatch(c -> c instanceof IClientTickableComponent);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.MULTIBLOCKSLAVE});
        builder.add(new Property[]{IEProperties.FACING_HORIZONTAL});
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (((Boolean)state.getValue((Property)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) {
            return this.multiblock.dummyBE().get().create(pos, state);
        }
        return this.multiblock.masterBE().get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> actual) {
        if (((Boolean)state.getValue((Property)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) {
            return null;
        }
        if (level.isClientSide && this.needsClientTicker) {
            return this.createTickerHelper(actual, ($1, $2, $3, blockEntity) -> blockEntity.getHelper().tickClient());
        }
        if (!level.isClientSide && this.needsServerTicker) {
            return this.createTickerHelper(actual, ($1, $2, $3, blockEntity) -> blockEntity.getHelper().tickServer());
        }
        return null;
    }

    @Nullable
    protected <A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> actual, BlockEntityTicker<MultiblockBlockEntityMaster<State>> ticker) {
        return this.multiblock.masterBE().get() == actual ? ticker : null;
    }

    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getShape(level, pos, context, ShapeType.COLLISION);
    }

    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getShape(level, pos, context, ShapeType.SELECTION);
    }

    @Nonnull
    public VoxelShape getBlockSupportShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return this.getShape(level, pos, null, ShapeType.BLOCK_SUPPORT);
    }

    @Nonnull
    private VoxelShape getShape(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable CollisionContext context, @Nonnull ShapeType type) {
        BlockEntity bEntity = level.getBlockEntity(pos);
        if (bEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)bEntity;
            return multiblockBE.getHelper().getShape(context, type);
        }
        return Shapes.block();
    }

    public void onRemove(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            super.onRemove(state, level, pos, newState, isMoving);
            multiblockBE.getHelper().disassemble();
            return;
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity bEntity = level.getBlockEntity(pos);
        if (bEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)bEntity;
            return multiblockBE.getHelper().click(player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public void entityInside(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        BlockEntity bEntity = level.getBlockEntity(pos);
        if (bEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)bEntity;
            multiblockBE.getHelper().onEntityCollided(entity);
        }
    }

    public boolean hasAnalogOutputSignal(@Nonnull BlockState state) {
        return this.multiblock.hasComparatorOutput();
    }

    public int getAnalogOutputSignal(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        BlockEntity blockEntity;
        if (this.multiblock.hasComparatorOutput() && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            return multiblockBE.getHelper().getComparatorValue();
        }
        return super.getAnalogOutputSignal(state, level, pos);
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (this.multiblock.redstoneInputAware() && (blockEntity = level.getBlockEntity(pos)) instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            multiblockBE.getHelper().onNeighborChanged(fromPos);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            return multiblockBE.getHelper().getPickBlock();
        }
        return ItemStack.EMPTY;
    }

    public boolean isPathfindable(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static class WithMirrorState<State extends IMultiblockState>
    extends MultiblockPartBlock<State> {
        public WithMirrorState(BlockBehaviour.Properties properties, MultiblockRegistration<State> multiblock) {
            super(properties, multiblock);
        }

        @Override
        protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{IEProperties.MIRRORED});
        }
    }
}

