/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.util;

import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Contract;

public enum RelativeBlockFace {
    FRONT,
    LEFT,
    BACK,
    RIGHT,
    UP,
    DOWN;

    public static final RelativeBlockFace[] HORIZONTAL;

    public Direction forFront(MultiblockOrientation orientation) {
        Direction front = orientation.front();
        boolean mirror = orientation.mirrored();
        Preconditions.checkArgument((boolean)front.getAxis().isHorizontal());
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FRONT -> front;
            case LEFT -> {
                if (mirror) {
                    yield front.getCounterClockWise();
                }
                yield front.getClockWise();
            }
            case BACK -> front.getOpposite();
            case RIGHT -> {
                if (mirror) {
                    yield front.getClockWise();
                }
                yield front.getCounterClockWise();
            }
            case UP -> Direction.UP;
            case DOWN -> Direction.DOWN;
        };
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static RelativeBlockFace from(MultiblockOrientation orientation, @Nullable Direction absoluteFace) {
        if (absoluteFace == null) {
            return null;
        }
        Direction front = orientation.front();
        boolean mirror = orientation.mirrored();
        Preconditions.checkArgument((boolean)front.getAxis().isHorizontal());
        if (absoluteFace == Direction.UP) {
            return UP;
        }
        if (absoluteFace == Direction.DOWN) {
            return DOWN;
        }
        int numRotations = Mth.positiveModulo((int)(front.get2DDataValue() - absoluteFace.get2DDataValue()), (int)4);
        return switch (numRotations) {
            case 0 -> FRONT;
            case 1 -> {
                if (mirror) {
                    yield LEFT;
                }
                yield RIGHT;
            }
            case 2 -> BACK;
            case 3 -> {
                if (mirror) {
                    yield RIGHT;
                }
                yield LEFT;
            }
            default -> throw new IllegalStateException("Unexpected value: " + numRotations);
        };
    }

    public BlockPos offsetRelative(BlockPos startPos, int amount) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FRONT -> startPos.relative(Direction.NORTH, amount);
            case LEFT -> startPos.relative(Direction.EAST, amount);
            case BACK -> startPos.relative(Direction.SOUTH, amount);
            case RIGHT -> startPos.relative(Direction.WEST, amount);
            case UP -> startPos.above(amount);
            case DOWN -> startPos.below(amount);
        };
    }

    public RelativeBlockFace getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FRONT -> BACK;
            case LEFT -> RIGHT;
            case BACK -> FRONT;
            case RIGHT -> LEFT;
            case UP -> DOWN;
            case DOWN -> UP;
        };
    }

    static {
        HORIZONTAL = new RelativeBlockFace[]{FRONT, LEFT, BACK, RIGHT};
    }
}

