/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class CapabilityShader {
    public static final ItemCapability<ShaderWrapper, Void> ITEM = ItemCapability.createVoid((ResourceLocation)IEApi.ieLoc("shader_item"), ShaderWrapper.class);
    public static final BlockCapability<ShaderWrapper, Void> BLOCK = BlockCapability.createVoid((ResourceLocation)IEApi.ieLoc("shader_block"), ShaderWrapper.class);
    public static ModelProperty<ShaderCase> MODEL_PROPERTY = new ModelProperty();

    public static boolean shouldReequipDueToShader(ItemStack oldStack, ItemStack newStack) {
        ShaderWrapper wrapperOld = (ShaderWrapper)oldStack.getCapability(ITEM);
        ShaderWrapper wrapperNew = (ShaderWrapper)newStack.getCapability(ITEM);
        if (wrapperOld == null && wrapperNew != null) {
            return true;
        }
        if (wrapperOld != null && wrapperNew == null) {
            return true;
        }
        if (wrapperOld != null) {
            return !ItemStack.matches((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem());
        }
        return false;
    }

    public static interface ShaderWrapper {
        public ResourceLocation getShaderType();

        public void setShaderItem(@Nonnull ItemStack var1);

        @Nonnull
        public ItemStack getShaderItem();

        default public ShaderCase getCase() {
            ItemStack shaderStack = this.getShaderItem();
            Item item = shaderStack.getItem();
            if (item instanceof IShaderItem) {
                IShaderItem shaderItem = (IShaderItem)item;
                return shaderItem.getShaderCase(shaderStack, this.getShaderType());
            }
            return null;
        }
    }

    public static final class WrapperSerializer
    implements IAttachmentSerializer<CompoundTag, ShaderWrapper_Direct> {
        public CompoundTag write(ShaderWrapper_Direct attachment) {
            CompoundTag nbt = new CompoundTag();
            ItemStack shader = attachment.getShaderItem();
            if (!shader.isEmpty()) {
                shader.save(nbt);
            } else {
                nbt.putString("IE:NoShader", "");
            }
            nbt.putString("IE:ShaderType", attachment.getShaderType().toString());
            return nbt;
        }

        public ShaderWrapper_Direct read(IAttachmentHolder holder, CompoundTag tag) {
            ShaderWrapper_Direct wrapper = new ShaderWrapper_Direct(new ResourceLocation(tag.getString("IE:ShaderType")));
            if (!tag.contains("IE:NoShader")) {
                wrapper.setShaderItem(ItemStack.of((CompoundTag)tag));
            }
            return wrapper;
        }
    }

    public static class ShaderWrapper_Direct
    implements ShaderWrapper {
        public static final IAttachmentSerializer<CompoundTag, ShaderWrapper_Direct> SERIALIZER = new WrapperSerializer();
        @Nonnull
        private ItemStack shader = ItemStack.EMPTY;
        private final ResourceLocation type;

        public ShaderWrapper_Direct(ResourceLocation type) {
            this.type = type;
        }

        @Override
        public ResourceLocation getShaderType() {
            return this.type;
        }

        @Override
        public void setShaderItem(@Nonnull ItemStack shader) {
            this.shader = shader;
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            return this.shader;
        }
    }

    public static class ShaderWrapper_Item
    implements ShaderWrapper {
        public static final String SHADER_NBT_KEY = "IE:Shader";
        private final ItemStack container;
        private final ResourceLocation shaderType;

        public ShaderWrapper_Item(ResourceLocation type, ItemStack container) {
            this.shaderType = type;
            this.container = container;
        }

        @Override
        public ResourceLocation getShaderType() {
            return this.shaderType;
        }

        @Override
        public void setShaderItem(@NotNull ItemStack shader) {
            if (!this.container.hasTag()) {
                this.container.setTag(new CompoundTag());
            }
            if (!shader.isEmpty()) {
                CompoundTag shaderTag = shader.save(new CompoundTag());
                this.container.getOrCreateTag().put(SHADER_NBT_KEY, (Tag)shaderTag);
            } else {
                this.container.getOrCreateTag().remove(SHADER_NBT_KEY);
            }
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            if (!this.container.hasTag()) {
                return ItemStack.EMPTY;
            }
            CompoundTag tagCompound = this.container.getOrCreateTag();
            if (!tagCompound.contains(SHADER_NBT_KEY, 10)) {
                return ItemStack.EMPTY;
            }
            return ItemStack.of((CompoundTag)tagCompound.getCompound(SHADER_NBT_KEY));
        }
    }
}

