/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.IEApi;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class MachineInterfaceHandler {
    public static ResourceLocation BASIC_ACTIVE = new ResourceLocation("immersiveengineering", "basic/active");
    public static ResourceLocation BASIC_ITEM_IN = new ResourceLocation("immersiveengineering", "basic/item_input");
    public static ResourceLocation BASIC_ITEM_OUT = new ResourceLocation("immersiveengineering", "basic/item_output");
    public static ResourceLocation BASIC_FLUID_IN = new ResourceLocation("immersiveengineering", "basic/fluid_input");
    public static ResourceLocation BASIC_FLUID_OUT = new ResourceLocation("immersiveengineering", "basic/fluid_output");
    public static ResourceLocation BASIC_ENERGY = new ResourceLocation("immersiveengineering", "basic/energy_storage");
    private static final Map<ResourceLocation, CheckOption<?>[]> CONDITION_REGISTRY = new HashMap<ResourceLocation, CheckOption<?>[]>();

    public static void register(ResourceLocation key, CheckOption<?> ... options) {
        CONDITION_REGISTRY.put(key, options);
    }

    public static void copyOptions(ResourceLocation newKey, ResourceLocation oldKey) {
        CONDITION_REGISTRY.put(newKey, CONDITION_REGISTRY.get(oldKey));
    }

    public static <T> CheckOption<T>[] buildComparativeConditions(ToDoubleFunction<T> tdf) {
        return new CheckOption[]{CheckOption.doubleCondition(new ResourceLocation("immersiveengineering", "comparator"), tdf), CheckOption.booleanCondition(new ResourceLocation("immersiveengineering", "empty"), h -> tdf.applyAsDouble(h) <= 0.0), CheckOption.booleanCondition(new ResourceLocation("immersiveengineering", "quarter"), h -> tdf.applyAsDouble(h) > 0.25), CheckOption.booleanCondition(new ResourceLocation("immersiveengineering", "half"), h -> tdf.applyAsDouble(h) > 0.5), CheckOption.booleanCondition(new ResourceLocation("immersiveengineering", "three_quarter"), h -> tdf.applyAsDouble(h) > 0.75), CheckOption.booleanCondition(new ResourceLocation("immersiveengineering", "full"), h -> tdf.applyAsDouble(h) >= 1.0)};
    }

    private static float getInventoryFill(IItemHandler itemHandler) {
        float f = 0.0f;
        int validSlots = 0;
        for (int iSlot = 0; iSlot < itemHandler.getSlots(); ++iSlot) {
            ItemStack itemstack = itemHandler.getStackInSlot(iSlot);
            if (!itemHandler.isItemValid(iSlot, itemstack)) continue;
            if (!itemstack.isEmpty()) {
                f += (float)itemstack.getCount() / (float)Math.min(itemHandler.getSlotLimit(iSlot), itemstack.getMaxStackSize());
            }
            ++validSlots;
        }
        return f /= (float)validSlots;
    }

    private static float getTankFill(IFluidHandler fluidHandler) {
        float f = 0.0f;
        for (int iTank = 0; iTank < fluidHandler.getTanks(); ++iTank) {
            FluidStack fluid = fluidHandler.getFluidInTank(iTank);
            if (fluid.isEmpty()) continue;
            f += (float)fluid.getAmount() / (float)fluidHandler.getTankCapacity(iTank);
        }
        return f /= (float)fluidHandler.getTanks();
    }

    private static float getEnergyFill(IEnergyStorage energyStorage) {
        return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
    }

    static {
        MachineInterfaceHandler.register(BASIC_ACTIVE, new CheckOption<BooleanSupplier>(new ResourceLocation("immersiveengineering", "yes"), value -> value.getAsBoolean() ? 15 : 0), new CheckOption<BooleanSupplier>(new ResourceLocation("immersiveengineering", "no"), value -> value.getAsBoolean() ? 0 : 15));
        MachineInterfaceHandler.register(BASIC_ITEM_IN, MachineInterfaceHandler.buildComparativeConditions(MachineInterfaceHandler::getInventoryFill));
        MachineInterfaceHandler.copyOptions(BASIC_ITEM_OUT, BASIC_ITEM_IN);
        MachineInterfaceHandler.register(BASIC_FLUID_IN, MachineInterfaceHandler.buildComparativeConditions(MachineInterfaceHandler::getTankFill));
        MachineInterfaceHandler.copyOptions(BASIC_FLUID_OUT, BASIC_FLUID_IN);
        MachineInterfaceHandler.register(BASIC_ENERGY, MachineInterfaceHandler.buildComparativeConditions(MachineInterfaceHandler::getEnergyFill));
    }

    public record CheckOption<T>(ResourceLocation name, ToIntFunction<T> condition) {
        public static <T> CheckOption<T> booleanCondition(ResourceLocation name, Predicate<T> predicate) {
            return new CheckOption<Object>(name, value -> predicate.test(value) ? 15 : 0);
        }

        public static <T> CheckOption<T> doubleCondition(ResourceLocation name, ToDoubleFunction<T> toDouble) {
            return new CheckOption<Object>(name, value -> Mth.ceil((double)(Math.max(toDouble.applyAsDouble(value), 0.0) * 15.0)));
        }

        public Component getName() {
            return Component.translatable((String)("gui." + this.name.getNamespace() + ".config.machine_interface.option." + this.name.getPath()));
        }

        public int getValue(T input) {
            return this.condition.applyAsInt(input);
        }
    }

    public static interface IMachineInterfaceConnection {
        public static final BlockCapability<IMachineInterfaceConnection, @Nullable Direction> CAPABILITY = BlockCapability.createSided((ResourceLocation)IEApi.ieLoc("machine_interface_connection"), IMachineInterfaceConnection.class);

        public MachineCheckImplementation<?>[] getAvailableChecks();
    }

    public record MachineCheckImplementation<T>(T instance, ResourceLocation key, CheckOption<T>[] options) {
        public MachineCheckImplementation(T instance, ResourceLocation key) {
            this(instance, key, CONDITION_REGISTRY.get(key));
        }

        public Component getName() {
            return Component.translatable((String)("gui." + this.key.getNamespace() + ".config.machine_interface.check." + this.key.getPath().replaceAll("/", ".")));
        }
    }
}

