/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.conveyor;

import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.PlayerUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IConveyorBelt {
    public static final VoxelShape conveyorBounds = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    public static final VoxelShape highConveyorBounds = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0);
    public static final VoxelShape FULL_BLOCK = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public BlockEntity getBlockEntity();

    public Direction getFacing();

    default public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return ConveyorHandler.ConveyorDirection.HORIZONTAL;
    }

    public boolean changeConveyorDirection();

    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection var1);

    default public void afterRotation(Direction oldDir, Direction newDir) {
    }

    public boolean isActive();

    public boolean setDyeColour(DyeColor var1);

    @Nullable
    public DyeColor getDyeColour();

    default public boolean playerInteraction(Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        return false;
    }

    default public Direction[] sigTransportDirections() {
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP) {
            return new Direction[]{this.getFacing(), Direction.UP};
        }
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.DOWN) {
            return new Direction[]{this.getFacing(), Direction.DOWN};
        }
        return new Direction[]{this.getFacing()};
    }

    default public Vec3 getDirection(Entity entity, boolean outputBlocked) {
        ConveyorHandler.ConveyorDirection conveyorDirection = this.getConveyorDirection();
        BlockPos pos = this.getBlockEntity().getBlockPos();
        Direction facing = this.getFacing();
        double vBase = 1.15;
        double vX = 0.1 * vBase * (double)facing.getStepX();
        double vY = entity.getDeltaMovement().y;
        double vZ = 0.1 * vBase * (double)facing.getStepZ();
        if (facing == Direction.WEST || facing == Direction.EAST) {
            if (entity.getZ() > (double)pos.getZ() + 0.55) {
                vZ = -0.1 * vBase;
            } else if (entity.getZ() < (double)pos.getZ() + 0.45) {
                vZ = 0.1 * vBase;
            }
        } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            if (entity.getX() > (double)pos.getX() + 0.55) {
                vX = -0.1 * vBase;
            } else if (entity.getX() < (double)pos.getX() + 0.45) {
                vX = 0.1 * vBase;
            }
        }
        if (conveyorDirection != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            Vec3 centerRelative = entity.position().subtract(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).subtract(0.5 + vX, 0.5, 0.5 + vZ);
            double conveyorHeight = 0.125;
            Vec3i directionVector = facing.getNormal();
            double centerOffsetInDirection = centerRelative.dot(new Vec3((double)directionVector.getX(), (double)directionVector.getY(), (double)directionVector.getZ()));
            double radius = entity.getDimensions((Pose)entity.getPose()).width / 2.0f;
            double maxEntityPos = centerOffsetInDirection + radius;
            double maxCenterHeightUnderEntity = maxEntityPos + 0.125;
            if (conveyorDirection == ConveyorHandler.ConveyorDirection.DOWN) {
                maxCenterHeightUnderEntity = -maxCenterHeightUnderEntity;
            }
            if (conveyorDirection == ConveyorHandler.ConveyorDirection.UP) {
                if (maxCenterHeightUnderEntity > centerRelative.y || !outputBlocked) {
                    vY = 0.17 * vBase;
                }
            } else {
                vY = Math.signum(maxCenterHeightUnderEntity - centerRelative.y) * 0.07 * vBase;
            }
            entity.setOnGround(false);
        }
        return new Vec3(vX, vY, vZ);
    }

    default public void onEntityCollision(@Nonnull Entity entity) {
        Player player;
        if (!this.isActive() || !entity.isAlive()) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).isShiftKeyDown() || player.getAbilities().flying)) {
            return;
        }
        PlayerUtils.resetFloatingState(entity);
        ConveyorHandler.ConveyorDirection conveyorDirection = this.getConveyorDirection();
        float heightLimit = conveyorDirection == ConveyorHandler.ConveyorDirection.HORIZONTAL ? 0.25f : 1.0f;
        BlockPos pos = this.getBlockEntity().getBlockPos();
        double relativeHeight = entity.getY() - (double)pos.getY();
        if (relativeHeight >= 0.0 && relativeHeight < (double)heightLimit) {
            boolean hasBeenHandled = !ConveyorHandler.markEntityAsHandled(entity);
            boolean outputBlocked = this.isOutputBlocked();
            Vec3 vec = this.getDirection(entity, outputBlocked);
            if (entity.fallDistance < 3.0f) {
                entity.fallDistance = 0.0f;
            }
            if (outputBlocked) {
                double replacementZ;
                double replacementX;
                if (hasBeenHandled) {
                    replacementX = entity.getDeltaMovement().x;
                    replacementZ = entity.getDeltaMovement().z;
                } else {
                    replacementX = 0.0;
                    replacementZ = 0.0;
                }
                vec = new Vec3(replacementX, vec.y, replacementZ);
            }
            entity.setDeltaMovement(vec);
            double distX = Math.abs((double)pos.relative(this.getFacing()).getX() + 0.5 - entity.getX());
            double distZ = Math.abs((double)pos.relative(this.getFacing()).getZ() + 0.5 - entity.getZ());
            double threshold = 0.9;
            boolean contact = this.getFacing().getAxis() == Direction.Axis.Z ? distZ < threshold : distX < threshold;
            Level w = (Level)Preconditions.checkNotNull((Object)this.getBlockEntity().getLevel());
            BlockPos upPos = pos.relative(this.getFacing()).above();
            if (contact && conveyorDirection == ConveyorHandler.ConveyorDirection.UP && !Block.isFaceFull((VoxelShape)w.getBlockState(upPos).getShape((BlockGetter)w, upPos), (Direction)Direction.DOWN)) {
                double move = 0.4;
                entity.setPos(entity.getX() + move * (double)this.getFacing().getStepX(), entity.getY() + 1.0 * move, entity.getZ() + move * (double)this.getFacing().getStepZ());
            }
            if (!contact) {
                ConveyorHandler.applyMagnetSuppression(entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
            } else {
                BlockPos nextPos = this.getBlockEntity().getBlockPos().relative(this.getFacing());
                if (!(SafeChunkUtils.getSafeBE((LevelAccessor)this.getBlockEntity().getLevel(), nextPos) instanceof ConveyorHandler.IConveyorBlockEntity)) {
                    ConveyorHandler.revertMagnetSuppression(entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
                }
            }
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (entity.tickCount > 1) {
                    if (!contact) {
                        ConveyorHandler.ItemAgeAccessor access = ConveyorHandler.ITEM_AGE_ACCESS.get();
                        if (item.getAge() > item.lifespan - 1200 && !outputBlocked) {
                            access.setAge(item, item.lifespan - 1200);
                        }
                    } else if (!w.isClientSide) {
                        this.handleInsertion(item, conveyorDirection, distX, distZ);
                    }
                }
            }
        }
    }

    default public boolean isBlocked() {
        return false;
    }

    default public boolean isOutputBlocked() {
        Level level = Objects.requireNonNull(this.getBlockEntity().getLevel());
        for (BlockPos pos : this.getNextConveyorCandidates()) {
            LevelChunk chunk = SafeChunkUtils.getSafeChunk((LevelAccessor)level, pos);
            if (chunk == null || !level.isClientSide && !chunk.getFullStatus().isOrAfter(FullChunkStatus.ENTITY_TICKING)) {
                return true;
            }
            BlockEntity outputTile = chunk.getBlockEntity(pos);
            if (!(outputTile instanceof ConveyorHandler.IConveyorBlockEntity)) continue;
            ConveyorHandler.IConveyorBlockEntity convOut = (ConveyorHandler.IConveyorBlockEntity)outputTile;
            return convOut.getConveyorInstance().isBlocked();
        }
        return false;
    }

    default public void onItemDeployed(ItemEntity entity) {
        ConveyorHandler.applyMagnetSuppression((Entity)entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
    }

    default public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        BlockPos invPos = this.getOutputInventory();
        Level world = this.getBlockEntity().getLevel();
        boolean contact = this.getFacing().getAxis() == Direction.Axis.Z ? distZ < 0.7 : distX < 0.7;
        BlockEntity inventoryTile = SafeChunkUtils.getSafeBE((LevelAccessor)world, invPos);
        if (!contact || inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity) {
            return;
        }
        ItemUtils.tryInsertEntity(world, invPos, this.getFacing().getOpposite(), entity);
    }

    default public BlockPos getOutputInventory() {
        ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
        return this.getBlockEntity().getBlockPos().relative(this.getFacing()).offset(0, conDir == ConveyorHandler.ConveyorDirection.UP ? 1 : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? -1 : 0), 0);
    }

    default public List<BlockPos> getNextConveyorCandidates() {
        ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
        BlockPos basePos = this.getOutputInventory();
        BlockPos alternative = conDir == ConveyorHandler.ConveyorDirection.DOWN ? basePos.above() : basePos.below();
        return ImmutableList.of((Object)basePos, (Object)alternative);
    }

    @Nullable
    default public IConveyorBelt getOutputConveyor() {
        for (BlockPos pos : this.getNextConveyorCandidates()) {
            BlockEntity outputTile = SafeChunkUtils.getSafeBE((LevelAccessor)this.getBlockEntity().getLevel(), pos);
            if (!(outputTile instanceof ConveyorHandler.IConveyorBlockEntity)) continue;
            ConveyorHandler.IConveyorBlockEntity convOut = (ConveyorHandler.IConveyorBlockEntity)outputTile;
            return convOut.getConveyorInstance();
        }
        return null;
    }

    default public void tickServer() {
    }

    default public VoxelShape getSelectionShape() {
        return this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL ? conveyorBounds : highConveyorBounds;
    }

    default public VoxelShape getCollisionShape() {
        return conveyorBounds;
    }

    public CompoundTag writeConveyorNBT();

    public void readConveyorNBT(CompoundTag var1);

    public IConveyorType<?> getType();

    public Block getCover();

    public static Block getCoverOrDefault(@Nullable IConveyorBelt belt, Block fallback) {
        return belt != null ? belt.getCover() : fallback;
    }

    public static boolean isCovered(@Nullable IConveyorBelt belt, Block fallback) {
        return IConveyorBelt.getCoverOrDefault(belt, fallback) != Blocks.AIR;
    }

    public void setCover(Block var1);
}

