/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;

public class DirectionUtils {
    public static final Direction[] VALUES = Direction.values();
    public static final Direction[] BY_HORIZONTAL_INDEX = (Direction[])Arrays.stream(VALUES).filter(direction -> direction.getAxis().isHorizontal()).sorted(Comparator.comparingInt(Direction::get2DDataValue)).toArray(Direction[]::new);

    public static Rotation getRotationBetweenFacings(Direction orig, Direction to) {
        if (to == orig) {
            return Rotation.NONE;
        }
        if (orig.getAxis() == Direction.Axis.Y || to.getAxis() == Direction.Axis.Y) {
            return null;
        }
        if ((orig = orig.getClockWise()) == to) {
            return Rotation.CLOCKWISE_90;
        }
        if ((orig = orig.getClockWise()) == to) {
            return Rotation.CLOCKWISE_180;
        }
        if ((orig = orig.getClockWise()) == to) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return null;
    }

    public static Direction rotateAround(Direction d, Direction.Axis axis) {
        if (axis == d.getAxis()) {
            return d;
        }
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> DirectionUtils.rotateX(d);
            case Direction.Axis.Y -> d.getClockWise();
            case Direction.Axis.Z -> DirectionUtils.rotateZ(d);
        };
    }

    public static Direction rotateX(Direction d) {
        return switch (d) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Direction.DOWN;
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.EAST, Direction.WEST -> throw new IllegalStateException("Unable to get X-rotated facing of " + d);
        };
    }

    public static Direction rotateZ(Direction d) {
        return switch (d) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("Unable to get Z-rotated facing of " + d);
        };
    }
}

