/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.shapes;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeUtils {
    public static AABB transformAABB(AABB original, Direction facing) {
        Vec3 minOld = new Vec3(original.minX - 0.5, original.minY - 0.5, original.minZ - 0.5);
        Vec3 maxOld = new Vec3(original.maxX - 0.5, original.maxY - 0.5, original.maxZ - 0.5);
        Vec3 firstNew = ShapeUtils.rotate(minOld, facing);
        Vec3 secondNew = ShapeUtils.rotate(maxOld, facing);
        return new AABB(firstNew.x + 0.5, firstNew.y + 0.5, firstNew.z + 0.5, secondNew.x + 0.5, secondNew.y + 0.5, secondNew.z + 0.5);
    }

    public static Vec3 rotate(Vec3 in, Direction to) {
        return switch (to) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> in;
            case Direction.SOUTH -> new Vec3(-in.x(), in.y(), -in.z());
            case Direction.EAST -> new Vec3(-in.z(), in.y(), in.x());
            case Direction.WEST -> new Vec3(in.z(), in.y(), -in.x());
            case Direction.DOWN, Direction.UP -> throw new RuntimeException("Unexpected direction: " + to);
        };
    }

    public static VoxelShape join(List<AABB> boxes) {
        VoxelShape ret = Shapes.empty();
        for (AABB aabb : boxes) {
            ret = Shapes.joinUnoptimized((VoxelShape)ret, (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.OR);
        }
        return ret.optimize();
    }
}

