/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.level.ChunkEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class NetworkSanitizer {
    private static final Map<LevelAccessor, Set<ChunkPos>> toSanitize = new WeakHashMap<LevelAccessor, Set<ChunkPos>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tick(LevelAccessor w, GlobalWireNetwork global) {
        Map<LevelAccessor, Set<ChunkPos>> map = toSanitize;
        synchronized (map) {
            Set<ChunkPos> relevant = toSanitize.get(w);
            if (relevant == null) {
                return;
            }
            Iterator<ChunkPos> iterator = relevant.iterator();
            while (iterator.hasNext()) {
                ChunkPos chunk = iterator.next();
                if (!SafeChunkUtils.isChunkSafe(w, chunk.getWorldPosition())) continue;
                ArrayList<ConnectionPoint> extraCPs = new ArrayList<ConnectionPoint>();
                HashSet<BlockPos> missingConnectors = new HashSet<BlockPos>();
                for (ConnectionPoint cp : global.getAllConnectorsIn(chunk)) {
                    if (missingConnectors.contains(cp.position())) continue;
                    BlockEntity inWorld = w.getBlockEntity(cp.position());
                    if (!(inWorld instanceof IImmersiveConnectable)) {
                        missingConnectors.add(cp.position());
                        continue;
                    }
                    IImmersiveConnectable iicWorld = (IImmersiveConnectable)inWorld;
                    if (iicWorld.getConnectionPoints().contains(cp)) continue;
                    extraCPs.add(cp);
                }
                for (ConnectionPoint cp : extraCPs) {
                    global.removeCP(cp);
                }
                for (BlockPos pos : missingConnectors) {
                    global.removeConnector(pos);
                }
                if (!extraCPs.isEmpty() || !missingConnectors.isEmpty()) {
                    WireLogger.logger.info("Removed {} extra connection points and {} missing connectors", (Object)extraCPs.size(), (Object)missingConnectors.size());
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load ev) {
        Map<LevelAccessor, Set<ChunkPos>> map = toSanitize;
        synchronized (map) {
            toSanitize.computeIfAbsent(ev.getLevel(), w -> new HashSet()).add(ev.getChunk().getPos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload ev) {
        Map<LevelAccessor, Set<ChunkPos>> map = toSanitize;
        synchronized (map) {
            Set<ChunkPos> forWorld = toSanitize.get(ev.getLevel());
            if (forWorld != null) {
                forWorld.remove(ev.getChunk().getPos());
            }
        }
    }
}

