/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WireLink {
    public final ConnectionPoint cp;
    public final ResourceKey<Level> dimension;
    public final BlockPos offset;
    public final TargetingInfo target;

    public WireLink(ConnectionPoint cp, ResourceKey<Level> dimension, BlockPos offset, TargetingInfo info) {
        this.cp = cp;
        this.dimension = dimension;
        this.offset = offset.immutable();
        this.target = info;
    }

    public static WireLink create(ConnectionPoint cp, Level world, BlockPos offset, TargetingInfo info) {
        return new WireLink(cp, (ResourceKey<Level>)world.dimension(), offset, info);
    }

    public void writeToItem(ItemStack stack) {
        CompoundTag nbt = stack.getOrCreateTag();
        nbt.putString("linkingDim", this.dimension.location().toString());
        nbt.put("linkingPos", (Tag)this.cp.createTag());
        nbt.put("linkingOffset", (Tag)NbtUtils.writeBlockPos((BlockPos)this.offset));
        CompoundTag targetNBT = new CompoundTag();
        this.target.writeToNBT(targetNBT);
        nbt.put("linkingTarget", (Tag)targetNBT);
    }

    public static WireLink readFromItem(ItemStack stack) {
        CompoundTag nbt = stack.hasTag() ? stack.getOrCreateTag() : new CompoundTag();
        ConnectionPoint cp = new ConnectionPoint(nbt.getCompound("linkingPos"));
        ResourceLocation dim = new ResourceLocation(nbt.getString("linkingDim"));
        BlockPos offset = NbtUtils.readBlockPos((CompoundTag)nbt.getCompound("linkingOffset"));
        TargetingInfo info = TargetingInfo.readFromNBT(nbt.getCompound("linkingTarget"));
        return new WireLink(cp, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim), offset, info);
    }
}

