/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.mixin.accessors.client.WorldRendererAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class BlockOverlayUtils {
    private static final Vec2[] quarterRotationArrowCoords = new Vec2[]{new Vec2(0.375f, 0.0f), new Vec2(0.5f, -0.125f), new Vec2(0.4375f, -0.125f), new Vec2(0.4375f, -0.25f), new Vec2(0.25f, -0.4375f), new Vec2(0.0f, -0.4375f), new Vec2(0.0f, -0.3125f), new Vec2(0.1875f, -0.3125f), new Vec2(0.3125f, -0.1875f), new Vec2(0.3125f, -0.125f), new Vec2(0.25f, -0.125f)};
    private static final Vec2[] quarterRotationArrowQuads = new Vec2[]{quarterRotationArrowCoords[5], quarterRotationArrowCoords[6], quarterRotationArrowCoords[4], quarterRotationArrowCoords[7], quarterRotationArrowCoords[3], quarterRotationArrowCoords[8], quarterRotationArrowCoords[2], quarterRotationArrowCoords[9], quarterRotationArrowCoords[1], quarterRotationArrowCoords[10], quarterRotationArrowCoords[0], quarterRotationArrowCoords[0]};
    private static final Vec2[] halfRotationArrowCoords = new Vec2[]{new Vec2(0.375f, 0.0f), new Vec2(0.5f, -0.125f), new Vec2(0.4375f, -0.125f), new Vec2(0.4375f, -0.25f), new Vec2(0.25f, -0.4375f), new Vec2(-0.25f, -0.4375f), new Vec2(-0.4375f, -0.25f), new Vec2(-0.4375f, -0.0625f), new Vec2(-0.3125f, -0.0625f), new Vec2(-0.3125f, -0.1875f), new Vec2(-0.1875f, -0.3125f), new Vec2(0.1875f, -0.3125f), new Vec2(0.3125f, -0.1875f), new Vec2(0.3125f, -0.125f), new Vec2(0.25f, -0.125f)};
    private static final Vec2[] halfRotationArrowQuads = new Vec2[]{halfRotationArrowCoords[7], halfRotationArrowCoords[8], halfRotationArrowCoords[6], halfRotationArrowCoords[9], halfRotationArrowCoords[5], halfRotationArrowCoords[10], halfRotationArrowCoords[4], halfRotationArrowCoords[11], halfRotationArrowCoords[3], halfRotationArrowCoords[12], halfRotationArrowCoords[2], halfRotationArrowCoords[13], halfRotationArrowCoords[1], halfRotationArrowCoords[14], halfRotationArrowCoords[0], halfRotationArrowCoords[0]};
    private static final float[][] arrowCoords = new float[][]{{0.0f, 0.375f}, {0.3125f, 0.0625f}, {0.125f, 0.0625f}, {0.125f, -0.375f}, {-0.125f, -0.375f}, {-0.125f, 0.0625f}, {-0.3125f, 0.0625f}};

    public static void drawBlockOverlayText(PoseStack transform, Component[] text, int scaledWidth, int scaledHeight) {
        if (text != null && text.length > 0) {
            BlockOverlayUtils.drawBlockOverlayText(transform, Arrays.asList(text), scaledWidth, scaledHeight);
        }
    }

    public static void drawBlockOverlayText(PoseStack transform, Iterable<Component> text, int scaledWidth, int scaledHeight) {
        int i = 0;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        for (Component s : text) {
            if (s == null) continue;
            Font font = ClientUtils.font();
            FormattedCharSequence formattedCharSequence = Language.getInstance().getVisualOrder((FormattedText)s);
            float f = scaledWidth / 2 + 8;
            int n = scaledHeight / 2 + 8;
            int n2 = i++;
            Objects.requireNonNull(ClientUtils.font());
            font.drawInBatch(formattedCharSequence, f, (float)(n + n2 * 9), -1, true, transform.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        buffer.endBatch();
    }

    public static void drawCircularRotationArrows(MultiBufferSource buffer, PoseStack transform, float rotation, boolean flip, boolean halfCircle) {
        int i;
        Matrix4f mat;
        int arrowId;
        int[] vertexOrder;
        Vec2[] rotationArrowQuads;
        Vec2[] rotationArrowCoords;
        transform.pushPose();
        transform.translate(0.0, 0.502, 0.0);
        if (halfCircle) {
            rotationArrowCoords = halfRotationArrowCoords;
            rotationArrowQuads = halfRotationArrowQuads;
        } else {
            rotationArrowCoords = quarterRotationArrowCoords;
            rotationArrowQuads = quarterRotationArrowQuads;
        }
        if (flip) {
            transform.mulPose(new Quaternionf().rotateXYZ(0.0f, -rotation, 0.0f));
            transform.scale(1.0f, 1.0f, -1.0f);
            vertexOrder = new int[]{2, 3, 1, 0};
        } else {
            transform.mulPose(new Quaternionf().rotateXYZ(0.0f, rotation, 0.0f));
            vertexOrder = new int[]{0, 1, 3, 2};
        }
        transform.pushPose();
        VertexConsumer builder = buffer.getBuffer(IERenderTypes.LINES);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.last().pose();
            for (i = 0; i < rotationArrowCoords.length; ++i) {
                Vec2 here = rotationArrowCoords[i];
                Vec2 next = rotationArrowCoords[(i + 1) % rotationArrowCoords.length];
                Vec2 diff = new Vec2(next.x - here.x, next.y - here.y).normalized();
                for (Vec2 v : ImmutableList.of((Object)here, (Object)next)) {
                    builder.vertex(mat, v.x, 0.0f, v.y).color(0.0f, 0.0f, 0.0f, 0.4f).normal(transform.last().normal(), diff.x, 0.0f, diff.y).endVertex();
                }
            }
            transform.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f));
        }
        transform.popPose();
        transform.pushPose();
        builder = buffer.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.last().pose();
            i = 0;
            while (i + 3 < rotationArrowQuads.length) {
                for (int offset : vertexOrder) {
                    Vec2 p = rotationArrowQuads[i + offset];
                    builder.vertex(mat, p.x, 0.0f, p.y).color(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).endVertex();
                }
                i += 2;
            }
            transform.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f));
        }
        transform.popPose();
        transform.popPose();
    }

    public static void drawBlockOverlayArrow(PoseStack.Pose transform, MultiBufferSource buffers, Vec3 directionVec, Direction side, AABB targetedBB) {
        Vec3[] translatedPositions = new Vec3[arrowCoords.length];
        Matrix4 mat = new Matrix4();
        Vec3 defaultDir = side.getAxis() == Direction.Axis.Y ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 1.0, 0.0);
        directionVec = directionVec.normalize();
        double angle = Math.acos(defaultDir.dot(directionVec));
        Vec3 axis = defaultDir.cross(directionVec);
        mat.rotate(angle, axis.x, axis.y, axis.z);
        if (side.getAxis() == Direction.Axis.Z) {
            mat.rotate(1.5707963267948966, 1.0, 0.0, 0.0).rotate(Math.PI, 0.0, 1.0, 0.0);
        } else if (side.getAxis() == Direction.Axis.X) {
            mat.rotate(1.5707963267948966, 0.0, 0.0, 1.0).rotate(1.5707963267948966, 0.0, 1.0, 0.0);
        }
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3 vec = mat.apply(new Vec3((double)arrowCoords[i][0], 0.0, (double)arrowCoords[i][1])).add(0.5, 0.5, 0.5);
            if (targetedBB != null) {
                vec = new Vec3(side == Direction.WEST ? targetedBB.minX - 0.002 : (side == Direction.EAST ? targetedBB.maxX + 0.002 : vec.x), side == Direction.DOWN ? targetedBB.minY - 0.002 : (side == Direction.UP ? targetedBB.maxY + 0.002 : vec.y), side == Direction.NORTH ? targetedBB.minZ - 0.002 : (side == Direction.SOUTH ? targetedBB.maxZ + 0.002 : vec.z));
            }
            translatedPositions[i] = vec;
        }
        VertexConsumer triBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_TRIANGLES);
        Vec3 center = translatedPositions[0];
        for (int i = 2; i < translatedPositions.length; ++i) {
            Vec3 point = translatedPositions[i];
            Vec3 prevPoint = translatedPositions[i - 1];
            for (Vec3 p : new Vec3[]{center, prevPoint, point}) {
                triBuilder.vertex(transform.pose(), (float)p.x, (float)p.y, (float)p.z).color(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).endVertex();
            }
        }
        VertexConsumer lineBuilder = buffers.getBuffer(IERenderTypes.LINES);
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3 point = translatedPositions[i];
            Vec3 next = translatedPositions[(i + 1) % translatedPositions.length];
            Vec3 diff = next.subtract(point).normalize();
            for (Vec3 p : ImmutableList.of((Object)point, (Object)next)) {
                lineBuilder.vertex(transform.pose(), (float)p.x, (float)p.y, (float)p.z).color(0.0f, 0.0f, 0.0f, 0.4f).normal(transform.normal(), (float)diff.x, (float)diff.y, (float)diff.z).endVertex();
            }
        }
    }

    public static void drawQuadrantX(PoseStack transform, MultiBufferSource buffers, Direction side, AABB targetedBB, float eps) {
        float y = (float)(targetedBB == null ? 0.0 : (side == Direction.DOWN ? targetedBB.minY - (double)eps : targetedBB.maxY + (double)eps));
        Matrix4f mat = transform.last().pose();
        Matrix3f matN = transform.last().normal();
        VertexConsumer lineBuilder = buffers.getBuffer(IERenderTypes.LINES);
        float sqrt2Half = (float)(Math.sqrt(2.0) / 2.0);
        lineBuilder.vertex(mat, 0.0f - eps, y, 0.0f - eps).color(0.0f, 0.0f, 0.0f, 0.4f).normal(matN, sqrt2Half, 0.0f, sqrt2Half).endVertex();
        lineBuilder.vertex(mat, 1.0f + eps, y, 1.0f + eps).color(0.0f, 0.0f, 0.0f, 0.4f).normal(matN, sqrt2Half, 0.0f, sqrt2Half).endVertex();
        lineBuilder.vertex(mat, 0.0f - eps, y, 1.0f + eps).color(0.0f, 0.0f, 0.0f, 0.4f).normal(matN, sqrt2Half, 0.0f, -sqrt2Half).endVertex();
        lineBuilder.vertex(mat, 1.0f + eps, y, 0.0f - eps).color(0.0f, 0.0f, 0.0f, 0.4f).normal(matN, sqrt2Half, 0.0f, -sqrt2Half).endVertex();
    }

    public static void drawAdditionalBlockbreak(RenderHighlightEvent.Block ev, Player player, Collection<BlockPos> blocks) {
        Vec3 renderView = ev.getCamera().getPosition();
        for (BlockPos pos : blocks) {
            ((WorldRendererAccess)ev.getLevelRenderer()).callRenderHitOutline(ev.getPoseStack(), ev.getMultiBufferSource().getBuffer(RenderType.lines()), (Entity)player, renderView.x, renderView.y, renderView.z, pos, ClientUtils.mc().level.getBlockState(pos));
        }
        PoseStack transform = ev.getPoseStack();
        transform.pushPose();
        transform.translate(-renderView.x, -renderView.y, -renderView.z);
        MultiPlayerGameMode controllerMP = ClientUtils.mc().gameMode;
        if (controllerMP.isDestroying()) {
            RenderUtils.drawBlockDamageTexture(transform, ev.getMultiBufferSource(), player.level(), blocks);
        }
        transform.popPose();
    }

    public static void renderOreveinMapOverlays(GuiGraphics graphics, ItemFrame frameEntity, HitResult rayTraceResult, int scaledWidth, int scaledHeight) {
        Level world;
        MapItemSavedData mapData;
        if (frameEntity == null) {
            return;
        }
        ItemStack frameItem = frameEntity.getItem();
        if (frameItem.getItem() == Items.FILLED_MAP && ItemNBTHelper.hasKey(frameItem, "Decorations", 9) && (mapData = MapItem.getSavedData((ItemStack)frameItem, (Level)(world = frameEntity.getCommandSenderWorld()))) != null) {
            Font font = ClientUtils.font();
            int mapScale = 1 << mapData.scale;
            float mapRotation = (float)(frameEntity.getRotation() % 4) * 1.5708f;
            Vec3 hitVec = rayTraceResult.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)frameEntity.getPos()));
            Direction frameDir = frameEntity.getDirection();
            double cursorH = 0.0;
            double cursorV = 0.0;
            switch (frameDir) {
                case DOWN: {
                    cursorH = hitVec.x;
                    cursorV = 1.0 - hitVec.z;
                    break;
                }
                case UP: {
                    cursorH = hitVec.x;
                    cursorV = hitVec.z;
                    break;
                }
                case NORTH: {
                    cursorH = 1.0 - hitVec.x;
                    cursorV = 1.0 - hitVec.y;
                    break;
                }
                case SOUTH: {
                    cursorH = hitVec.x;
                    cursorV = 1.0 - hitVec.y;
                    break;
                }
                case WEST: {
                    cursorH = hitVec.z;
                    cursorV = 1.0 - hitVec.y;
                    break;
                }
                case EAST: {
                    cursorH = 1.0 - hitVec.z;
                    cursorV = 1.0 - hitVec.y;
                }
            }
            cursorH *= 128.0;
            cursorV *= 128.0;
            ListTag minerals = null;
            double lastDist = Double.MAX_VALUE;
            ListTag nbttaglist = frameItem.getTag().getList("Decorations", 10);
            for (Tag inbt : nbttaglist) {
                CompoundTag tagCompound = (CompoundTag)inbt;
                String id = tagCompound.getString("id");
                if (!id.startsWith("ie:coresample_") || !tagCompound.contains("minerals")) continue;
                double sampleX = tagCompound.getDouble("x");
                double sampleZ = tagCompound.getDouble("z");
                float f = (float)(sampleX - (double)mapData.centerX) / (float)mapScale;
                float f1 = (float)(sampleZ - (double)mapData.centerZ) / (float)mapScale;
                byte b0 = (byte)((double)(f * 2.0f) + 0.5);
                byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
                Vec3 mapPos = new Vec3(0.0, (double)b1, (double)b0);
                mapPos = mapPos.xRot(mapRotation);
                double offsetH = mapPos.z / 2.0 + 64.0;
                double dH = cursorH - offsetH;
                double offsetV = mapPos.y / 2.0 + 64.0;
                double dV = cursorV - offsetV;
                double dist = dH * dH + dV * dV;
                if (!(dist < 10.0) || !(dist < lastDist)) continue;
                lastDist = dist;
                minerals = tagCompound.getList("minerals", 8);
            }
            if (minerals != null) {
                for (int i = 0; i < minerals.size(); ++i) {
                    ResourceLocation id = new ResourceLocation(minerals.getString(i));
                    MineralMix mix = MineralMix.RECIPES.getById((Level)Minecraft.getInstance().level, id);
                    if (mix == null) continue;
                    String string = I18n.get((String)MineralMix.getTranslationKey(id), (Object[])new Object[0]);
                    int n = scaledWidth / 2 + 8;
                    int n2 = scaledHeight / 2 + 8;
                    Objects.requireNonNull(font);
                    graphics.drawString(font, string, n, n2 + i * 9, 0xFFFFFF, true);
                }
            }
        }
    }
}

