/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.client.BlockOverlayUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.IEKeybinds;
import blusunrize.immersiveengineering.client.ItemOverlayUtils;
import blusunrize.immersiveengineering.client.LevelStageRenders;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.render.tile.BlueprintRenderer;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WindowBlock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.blocks.wooden.TurntableBlockEntity;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.client.WorldRendererAccess;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.client.gui.overlay.VanillaGuiOverlay;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Quaternionf;

public class ClientEventHandler
implements ResourceManagerReloadListener {
    private boolean shieldToggleButton = false;
    private int shieldToggleTimer = 0;

    public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
        ImmersiveEngineering.proxy.clearRenderCaches();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.player != null && event.player == ClientUtils.mc().getCameraEntity() && event.phase == TickEvent.Phase.END) {
            ItemStack held;
            if (this.shieldToggleTimer > 0) {
                --this.shieldToggleTimer;
            }
            if (IEKeybinds.keybind_magnetEquip.isDown() && !this.shieldToggleButton) {
                if (this.shieldToggleTimer <= 0) {
                    this.shieldToggleTimer = 7;
                } else {
                    Player player = event.player;
                    ItemStack held2 = player.getItemInHand(InteractionHand.OFF_HAND);
                    if (!held2.isEmpty() && held2.getItem() instanceof IEShieldItem) {
                        if (((IEShieldItem)held2.getItem()).getUpgrades(held2).getBoolean("magnet") && ((IEShieldItem)held2.getItem()).getUpgrades(held2).contains("prevSlot")) {
                            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageMagnetEquip(-1)});
                        }
                    } else {
                        for (int i = 0; i < player.getInventory().items.size(); ++i) {
                            ItemStack s = (ItemStack)player.getInventory().items.get(i);
                            if (s.isEmpty() || !(s.getItem() instanceof IEShieldItem) || !((IEShieldItem)s.getItem()).getUpgrades(s).getBoolean("magnet")) continue;
                            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageMagnetEquip(i)});
                        }
                    }
                }
            }
            if (this.shieldToggleButton != ClientUtils.mc().options.keyDown.isDown()) {
                this.shieldToggleButton = ClientUtils.mc().options.keyDown.isDown();
            }
            if (!IEKeybinds.keybind_chemthrowerSwitch.isUnbound() && IEKeybinds.keybind_chemthrowerSwitch.consumeClick() && (held = event.player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof IEItemInterfaces.IScrollwheel) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageScrollwheelItem(true)});
            }
            if (!IEKeybinds.keybind_railgunZoom.isUnbound() && IEKeybinds.keybind_railgunZoom.consumeClick()) {
                for (InteractionHand hand : InteractionHand.values()) {
                    float[] steps;
                    ItemStack held3 = event.player.getItemInHand(hand);
                    if (!(held3.getItem() instanceof ZoomHandler.IZoomTool) || !((ZoomHandler.IZoomTool)held3.getItem()).canZoom(held3, event.player)) continue;
                    boolean bl = ZoomHandler.isZooming = !ZoomHandler.isZooming;
                    if (!ZoomHandler.isZooming || (steps = ((ZoomHandler.IZoomTool)held3.getItem()).getZoomSteps(held3, event.player)) == null || steps.length <= 0) continue;
                    ZoomHandler.fovZoom = steps[ZoomHandler.getCurrentZoomStep(steps)];
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        LevelStageRenders.FAILED_CONNECTIONS.entrySet().removeIf(entry -> ((MutableInt)((Pair)entry.getValue()).getSecond()).decrementAndGet() <= 0);
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            GlobalWireNetwork.getNetwork((Level)world).update((Level)world);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack earmuffs;
        ItemStack shader;
        if (event.getItemStack().isEmpty()) {
            return;
        }
        CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)event.getItemStack().getCapability(CapabilityShader.ITEM);
        if (wrapper != null && !(shader = wrapper.getShaderItem()).isEmpty()) {
            event.getToolTip().add(TextUtils.applyFormat(shader.getHoverName(), ChatFormatting.DARK_GRAY));
        }
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Earmuffs") && !(earmuffs = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Earmuffs")).isEmpty()) {
            event.getToolTip().add(TextUtils.applyFormat(earmuffs.getHoverName(), ChatFormatting.GRAY));
        }
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Powerpack")) {
            ItemStack powerpack = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Powerpack");
            IEnergyStorage packStorage = (IEnergyStorage)powerpack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (!powerpack.isEmpty() && packStorage != null) {
                List tooltip = event.getToolTip();
                int idx = IntStream.range(0, tooltip.size()).filter(i -> tooltip.get(i) == CommonComponents.EMPTY).findFirst().orElse(tooltip.size() - 1);
                tooltip.add(idx++, CommonComponents.EMPTY);
                tooltip.add(idx++, TextUtils.applyFormat(powerpack.getHoverName(), ChatFormatting.GRAY));
                tooltip.add(idx++, TextUtils.applyFormat((Component)Component.literal((String)(packStorage.getEnergyStored() + "/" + packStorage.getMaxEnergyStored() + " IF")), ChatFormatting.GRAY));
                tooltip.add(idx, TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.noChargeOnArmor"), ChatFormatting.DARK_GRAY));
            }
        }
        ClientLevel clientLevel = ClientUtils.mc().level;
        if (ClientUtils.mc().screen != null && ClientUtils.mc().screen instanceof BlastFurnaceScreen && BlastFurnaceFuel.isValidBlastFuel((Level)clientLevel, event.getItemStack())) {
            event.getToolTip().add(TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.blastFuelTime", (Object[])new Object[]{BlastFurnaceFuel.getBlastFuelTime((Level)clientLevel, event.getItemStack())}), ChatFormatting.GRAY));
        }
        if (((Boolean)IEClientConfig.tagTooltips.get()).booleanValue() && event.getFlags().isAdvanced()) {
            event.getItemStack().getItem().builtInRegistryHolder().tags().map(TagKey::location).forEach(oid -> event.getToolTip().add(TextUtils.applyFormat((Component)Component.literal((String)oid.toString()), ChatFormatting.GRAY)));
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        List<RecipeHolder<BlueprintCraftingRecipe>> recipes;
        double playerDistanceSq;
        if (event.getItemStack().getItem() instanceof EngineersBlueprintItem && (playerDistanceSq = ClientUtils.mc().player.distanceToSqr((Entity)event.getItemFrameEntity())) < 1000.0 && !(recipes = BlueprintCraftingRecipe.findRecipes(event.getItemFrameEntity().level(), ItemNBTHelper.getString(event.getItemStack(), "blueprint"))).isEmpty()) {
            BlueprintRenderer.BlueprintLines blueprint;
            int i = event.getItemFrameEntity().getRotation();
            BlueprintCraftingRecipe recipe = (BlueprintCraftingRecipe)recipes.get(i % recipes.size()).value();
            BlueprintRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : BlueprintRenderer.getBlueprintDrawable(recipe, event.getItemFrameEntity().getCommandSenderWorld());
            if (blueprint != null) {
                PoseStack transform = event.getPoseStack();
                transform.pushPose();
                MultiBufferSource buffer = event.getMultiBufferSource();
                transform.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.0f, (float)(-i) * (float)Math.PI / 4.0f));
                transform.translate(-0.5, 0.5, -0.001);
                VertexConsumer builder = buffer.getBuffer(IERenderTypes.getGui(ImmersiveEngineering.rl("textures/models/blueprint_frame.png")));
                GuiHelper.drawTexturedColoredRect(builder, transform, 0.125f, -0.875f, 0.75f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                transform.translate(0.75, -0.25, -0.002);
                float scale = 0.0375f / ((float)blueprint.getTextureScale() / 16.0f);
                transform.scale(-scale, -scale, scale);
                blueprint.draw(transform, buffer, event.getPackedLight());
                transform.popPose();
                event.setCanceled(true);
            }
        }
    }

    private static void handleSubtitleOffset(boolean pre) {
        float offset = 0.0f;
        LocalPlayer player = ClientUtils.mc().player;
        for (InteractionHand hand : InteractionHand.values()) {
            if (player.getItemInHand(hand).isEmpty()) continue;
            Item equipped = player.getItemInHand(hand).getItem();
            if (equipped instanceof RevolverItem || equipped instanceof SpeedloaderItem) {
                offset = 50.0f;
                continue;
            }
            if (equipped instanceof DrillItem || equipped instanceof ChemthrowerItem || equipped instanceof BuzzsawItem) {
                offset = 50.0f;
                continue;
            }
            if (!(equipped instanceof RailgunItem) && !(equipped instanceof IEShieldItem)) continue;
            offset = 20.0f;
        }
        if (offset != 0.0f) {
            if (pre) {
                offset *= -1.0f;
            }
            RenderSystem.getModelViewStack().translate(0.0f, offset, 0.0f);
            RenderSystem.applyModelViewMatrix();
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.SUBTITLES.id())) {
            ClientEventHandler.handleSubtitleOffset(true);
        }
        if (ZoomHandler.isZooming && event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
            event.setCanceled(true);
            if (ZoomHandler.isZooming) {
                ZoomHandler.IZoomTool tool;
                float[] steps;
                Item item;
                MultiBufferSource.BufferSource buffers = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
                PoseStack transform = new PoseStack();
                transform.pushPose();
                int width = ClientUtils.mc().getWindow().getGuiScaledWidth();
                int height = ClientUtils.mc().getWindow().getGuiScaledHeight();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    GuiHelper.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216, (MultiBufferSource)buffers, transform);
                    GuiHelper.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216, (MultiBufferSource)buffers, transform);
                } else {
                    GuiHelper.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216, (MultiBufferSource)buffers, transform);
                    GuiHelper.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216, (MultiBufferSource)buffers, transform);
                }
                transform.translate(offsetX, offsetY, 0.0f);
                VertexConsumer builder = buffers.getBuffer(IERenderTypes.getGuiTranslucent(ImmersiveEngineering.rl("textures/gui/scope.png")));
                GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, 0.0f, resMin, resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
                builder = buffers.getBuffer(IERenderTypes.getGui(ImmersiveEngineering.rl("textures/gui/hud_elements.png")));
                GuiHelper.drawTexturedColoredRect(builder, transform, 0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.25f, 0.34375f, 0.375f, 0.875f);
                ItemStack equipped = ClientUtils.mc().player.getItemInHand(InteractionHand.MAIN_HAND);
                if (!equipped.isEmpty() && (item = equipped.getItem()) instanceof ZoomHandler.IZoomTool && (steps = (tool = (ZoomHandler.IZoomTool)item).getZoomSteps(equipped, (Player)ClientUtils.mc().player)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    transform.translate(0.87109375f * (float)resMin, 0.25f * (float)resMin, 0.0f);
                    transform.translate(0.0f, (5.0f + stepOffset) / 256.0f * (float)resMin, 0.0f);
                    for (int i = 0; i < steps.length; ++i) {
                        GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.34375f, 0.375f, 0.375f, 0.40234375f);
                        transform.translate(0.0f, stepLength / 256.0f * (float)resMin, 0.0f);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                    }
                    transform.translate(0.0f, -totalOffset / 256.0f * (float)resMin, 0.0f);
                    if (curStep < steps.length) {
                        transform.translate(0.0234375f * (float)resMin, (float)curStep * stepLength / 256.0f * (float)resMin, 0.0f);
                        GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.34375f, 0.3828125f, 0.40234375f, 0.4296875f);
                        ClientUtils.font().drawInBatch(1.0f / steps[curStep] + "x", (float)((int)(0.0625f * (float)resMin)), 0.0f, 0xFFFFFF, true, transform.last().pose(), (MultiBufferSource)buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                        transform.translate(-0.0234375f * (float)resMin, (float)(-curStep) * stepLength / 256.0f * (float)resMin, 0.0f);
                    }
                    transform.translate(0.0f, -((5.0f + stepOffset) / 256.0f * (float)resMin), 0.0f);
                    transform.translate(-0.87109375f * (float)resMin, -0.25f * (float)resMin, 0.0f);
                }
                transform.translate(-offsetX, -offsetY, 0.0f);
                buffers.endBatch();
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGuiOverlayEvent.Post event) {
        int leftHeight;
        Gui gui;
        int scaledWidth = ClientUtils.mc().getWindow().getGuiScaledWidth();
        int scaledHeight = ClientUtils.mc().getWindow().getGuiScaledHeight();
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.SUBTITLES.id())) {
            ClientEventHandler.handleSubtitleOffset(false);
        }
        if ((gui = Minecraft.getInstance().gui) instanceof ExtendedGui) {
            ExtendedGui forgeUI = (ExtendedGui)gui;
            leftHeight = forgeUI.leftHeight;
        } else {
            leftHeight = 0;
        }
        if (ClientUtils.mc().player != null && event.getOverlay().id().equals((Object)VanillaGuiOverlay.ITEM_NAME.id())) {
            LocalPlayer player = ClientUtils.mc().player;
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack transform = graphics.pose();
            for (InteractionHand hand : InteractionHand.values()) {
                if (player.getItemInHand(hand).isEmpty()) continue;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
                ItemStack equipped = player.getItemInHand(hand);
                if (equipped.is(IEItems.Tools.VOLTMETER.asItem()) || equipped.getItem() instanceof IWireCoil) {
                    if (WirecoilUtils.hasWireLink(equipped)) {
                        int max;
                        HitResult rtr;
                        double d;
                        WireLink link = WireLink.readFromItem(equipped);
                        BlockPos pos = link.cp.position();
                        String s = I18n.get((String)"desc.immersiveengineering.info.attachedTo", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()});
                        int col = WireType.ELECTRUM.getColour(null);
                        if (equipped.getItem() instanceof IWireCoil && (d = (rtr = ClientUtils.mc().hitResult) instanceof BlockHitResult ? ((BlockHitResult)rtr).getBlockPos().distSqr((Vec3i)pos) : player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) > (double)((max = ((IWireCoil)equipped.getItem()).getWireType(equipped).getMaxLength()) * max)) {
                            col = 0xDD3333;
                        }
                        ClientUtils.font().drawInBatch(s, (float)(scaledWidth / 2 - ClientUtils.font().width(s) / 2), (float)(scaledHeight - leftHeight - 20), col, true, transform.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    }
                } else if (equipped.getItem() == IEItems.Misc.FLUORESCENT_TUBE.get()) {
                    int color = FluorescentTubeItem.getRGBInt(equipped, 1.0f);
                    String s = I18n.get((String)"desc.immersiveengineering.info.colour", (Object[])new Object[0]) + "#" + FontUtils.hexColorString(color);
                    ClientUtils.font().drawInBatch(s, (float)(scaledWidth / 2 - ClientUtils.font().width(s) / 2), (float)(scaledHeight - leftHeight - 20), FluorescentTubeItem.getRGBInt(equipped, 1.0f), true, transform.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                } else if (equipped.getItem() instanceof RevolverItem || equipped.getItem() instanceof SpeedloaderItem) {
                    ItemOverlayUtils.renderRevolverOverlay(buffer, graphics, scaledWidth, scaledHeight, (Player)player, hand, equipped);
                } else if (equipped.getItem() instanceof RailgunItem) {
                    ItemOverlayUtils.renderRailgunOverlay(buffer, transform, scaledWidth, scaledHeight, (Player)player, hand, equipped);
                } else if (equipped.getItem() instanceof DrillItem) {
                    ItemOverlayUtils.renderDrillOverlay(buffer, transform, scaledWidth, scaledHeight, (Player)player, hand, equipped);
                } else if (equipped.getItem() instanceof BuzzsawItem) {
                    ItemOverlayUtils.renderBuzzsawOverlay(buffer, transform, scaledWidth, scaledHeight, (Player)player, hand, equipped);
                } else if (equipped.getItem() instanceof ChemthrowerItem) {
                    ItemOverlayUtils.renderChemthrowerOverlay(buffer, transform, scaledWidth, scaledHeight, (Player)player, hand, equipped);
                } else if (equipped.getItem() instanceof IEShieldItem) {
                    ItemOverlayUtils.renderShieldOverlay(buffer, transform, scaledWidth, scaledHeight, (Player)player, hand, equipped);
                }
                if (equipped.getItem() == IEItems.Tools.VOLTMETER.get()) {
                    this.renderVoltmeterOverlay((Player)player, scaledWidth, scaledHeight, transform, (MultiBufferSource)buffer);
                }
                buffer.endBatch();
                Lighting.setupFor3DItems();
            }
            if (ClientUtils.mc().hitResult != null) {
                ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
                boolean hammer = !held.isEmpty() && Utils.isHammer(held);
                HitResult mop = ClientUtils.mc().hitResult;
                if (mop instanceof EntityHitResult) {
                    IEMinecartEntity ieMinecart;
                    Object color;
                    Entity entity2 = ((EntityHitResult)mop).getEntity();
                    if (entity2 instanceof ItemFrame) {
                        BlockOverlayUtils.renderOreveinMapOverlays(graphics, (ItemFrame)entity2, mop, scaledWidth, scaledHeight);
                    } else if (entity2 instanceof IEMinecartEntity && (color = (ieMinecart = (IEMinecartEntity)entity2).getContainedBlockEntity()) instanceof IEBlockInterfaces.IBlockOverlayText) {
                        IEBlockInterfaces.IBlockOverlayText overlayText = (IEBlockInterfaces.IBlockOverlayText)color;
                        Component[] text = overlayText.getOverlayText((Player)player, mop, false);
                        BlockOverlayUtils.drawBlockOverlayText(transform, text, scaledWidth, scaledHeight);
                    }
                } else if (mop instanceof BlockHitResult) {
                    List list;
                    IMultiblockBE multiblock;
                    BlockPos pos = ((BlockHitResult)mop).getBlockPos();
                    Direction face = ((BlockHitResult)mop).getDirection();
                    BlockEntity tileEntity = player.level().getBlockEntity(pos);
                    if (tileEntity instanceof IEBlockInterfaces.IBlockOverlayText) {
                        IEBlockInterfaces.IBlockOverlayText overlayBlock = (IEBlockInterfaces.IBlockOverlayText)tileEntity;
                        Component[] text = overlayBlock.getOverlayText((Player)ClientUtils.mc().player, mop, hammer);
                        BlockOverlayUtils.drawBlockOverlayText(transform, text, scaledWidth, scaledHeight);
                    } else if (!(tileEntity instanceof IMultiblockBE && this.renderMultiblockOverlay(multiblock = (IMultiblockBE)tileEntity, hammer, transform, scaledWidth, scaledHeight) || (list = player.level().getEntitiesOfClass(ItemFrame.class, new AABB(pos.relative(face)), entity -> entity != null && entity.getDirection() == face)).size() != 1)) {
                        BlockOverlayUtils.renderOreveinMapOverlays(graphics, (ItemFrame)list.get(0), mop, scaledWidth, scaledHeight);
                    }
                }
            }
        }
    }

    private <S extends IMultiblockState> boolean renderMultiblockOverlay(IMultiblockBE<S> be, boolean hammer, PoseStack transform, int scaledWidth, int scaledHeight) {
        IMultiblockBEHelper<S> helper = be.getHelper();
        IMultiblockLogic<S> iMultiblockLogic = helper.getMultiblock().logic();
        if (!(iMultiblockLogic instanceof MBOverlayText)) {
            return false;
        }
        MBOverlayText overlayHandler = (MBOverlayText)iMultiblockLogic;
        List<Component> overlayText = overlayHandler.getOverlayText(helper.getState(), (Player)ClientUtils.mc().player, hammer);
        if (overlayText == null) {
            return false;
        }
        BlockOverlayUtils.drawBlockOverlayText(transform, overlayText, scaledWidth, scaledHeight);
        return true;
    }

    private void renderVoltmeterOverlay(Player player, float scaledWidth, float scaledHeight, PoseStack transform, MultiBufferSource buffer) {
        HitResult rrt = ClientUtils.mc().hitResult;
        FastEither<Object, Object> pos = null;
        if (rrt instanceof BlockHitResult) {
            BlockHitResult mop = (BlockHitResult)rrt;
            pos = FastEither.left(mop.getBlockPos());
        } else if (rrt instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)rrt;
            pos = FastEither.right(ehr.getEntity().getId());
        }
        if (pos == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        boolean matches = VoltmeterItem.lastEnergyUpdate.pos().equals(pos);
        long sinceLast = player.level().getGameTime() - VoltmeterItem.lastEnergyUpdate.measuredInTick();
        if (!matches || sinceLast > 20L) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageRequestEnergyUpdate(pos)});
        }
        if (VoltmeterItem.lastEnergyUpdate.isValid() && matches) {
            int maxStorage = VoltmeterItem.lastEnergyUpdate.capacity();
            int storage = VoltmeterItem.lastEnergyUpdate.stored();
            String storageText = Utils.toScientificNotation(storage, "0##", 100000);
            String capacityText = Utils.toScientificNotation(maxStorage, "0##", 100000);
            text.addAll(Arrays.asList(I18n.get((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{"<br>" + storageText + " / " + capacityText}).split("<br>")));
        }
        if (pos.isLeft()) {
            matches = VoltmeterItem.lastRedstoneUpdate.pos().equals(pos.leftNonnull());
            sinceLast = player.level().getGameTime() - VoltmeterItem.lastRedstoneUpdate.measuredInTick();
            if (!matches || sinceLast > 20L) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageRequestRedstoneUpdate((BlockPos)pos.leftNonnull())});
            }
            if (VoltmeterItem.lastRedstoneUpdate.isSignalSource() && matches) {
                text.addAll(Arrays.asList(I18n.get((String)"desc.immersiveengineering.info.redstoneLevel", (Object[])new Object[]{"<br>" + VoltmeterItem.lastRedstoneUpdate.rsLevel()}).split("<br>")));
            }
        }
        if (text != null) {
            int col = 0xFFFFFF;
            int i = 0;
            RenderSystem.enableBlend();
            for (String s : text) {
                if (s == null) continue;
                s = s.trim();
                int w = ClientUtils.font().width(s);
                Font font = ClientUtils.font();
                float f = scaledWidth / 2.0f - (float)w / 2.0f;
                float f2 = scaledHeight / 2.0f + 4.0f;
                int n = i++;
                Objects.requireNonNull(ClientUtils.font());
                font.drawInBatch(s, f, f2 + (float)(n * (9 + 2)), col, false, transform.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public void onFogUpdate(ViewportEvent.RenderFog event) {
        LivingEntity living;
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect((MobEffect)IEPotions.FLASHED.value())) {
            MobEffectInstance effect = living.getEffect((MobEffect)IEPotions.FLASHED.value());
            int timeLeft = effect.getDuration();
            float saturation = Math.max(0.25f, 1.0f - (float)timeLeft / (float)(80 + 40 * effect.getAmplifier()));
            float f1 = -2.5f + 15.0f * saturation;
            if (timeLeft < 20) {
                f1 += event.getFarPlaneDistance() / 4.0f * (1.0f - (float)timeLeft / 20.0f);
            }
            RenderSystem.setShaderFogStart((float)(0.25f * f1));
            RenderSystem.setShaderFogEnd((float)f1);
        }
    }

    @SubscribeEvent
    public void onFogColourUpdate(ViewportEvent.ComputeFogColor event) {
        Entity e = event.getCamera().getEntity();
        if (e instanceof LivingEntity && ((LivingEntity)e).hasEffect((MobEffect)IEPotions.FLASHED.value())) {
            event.setRed(1.0f);
            event.setGreen(1.0f);
            event.setBlue(1.0f);
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(ComputeFovModifierEvent event) {
        boolean mayZoom;
        LocalPlayer player = ClientUtils.mc().player;
        ItemStack equipped = player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean bl = mayZoom = equipped.getItem() instanceof ZoomHandler.IZoomTool && ((ZoomHandler.IZoomTool)equipped.getItem()).canZoom(equipped, (Player)player);
        if (ZoomHandler.isZooming) {
            if (mayZoom) {
                event.setNewFovModifier(ZoomHandler.fovZoom);
            } else {
                ZoomHandler.isZooming = false;
            }
        }
        if (player.getEffect((MobEffect)IEPotions.CONCRETE_FEET.value()) != null) {
            event.setNewFovModifier(1.0f);
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = ClientUtils.mc().player;
        if (event.getScrollDeltaY() != 0.0 && ClientUtils.mc().screen == null && player != null) {
            float[] steps;
            ItemStack equipped = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (equipped.getItem() instanceof ZoomHandler.IZoomTool && ((ZoomHandler.IZoomTool)equipped.getItem()).canZoom(equipped, (Player)player) && ZoomHandler.isZooming && (steps = ((ZoomHandler.IZoomTool)equipped.getItem()).getZoomSteps(equipped, (Player)player)) != null && steps.length > 0) {
                int curStep = ZoomHandler.getCurrentZoomStep(steps);
                int newStep = curStep + (event.getScrollDeltaY() > 0.0 ? -1 : 1);
                if (newStep >= 0 && newStep < steps.length) {
                    ZoomHandler.fovZoom = steps[newStep];
                }
                event.setCanceled(true);
            }
            if (player.isShiftKeyDown()) {
                if (((Boolean)IEServerConfig.TOOLS.chemthrower_scroll.get()).booleanValue() && equipped.getItem() instanceof IEItemInterfaces.IScrollwheel) {
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageScrollwheelItem(event.getScrollDeltaY() < 0.0)});
                    event.setCanceled(true);
                }
                if (equipped.getItem() instanceof RevolverItem) {
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageRevolverRotate(event.getScrollDeltaY() < 0.0)});
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(RenderHighlightEvent.Block event) {
        Entity entity;
        if (event.getTarget().getType() == HitResult.Type.BLOCK && (entity = event.getCamera().getEntity()) instanceof LivingEntity) {
            ItemStack head;
            DrillItem drillItem;
            Item shape;
            LivingEntity living = (LivingEntity)entity;
            PoseStack transform = event.getPoseStack();
            MultiBufferSource buffer = event.getMultiBufferSource();
            BlockHitResult rtr = event.getTarget();
            BlockPos pos = rtr.getBlockPos();
            Level world = living.level();
            BlockState targetBlock = world.getBlockState(rtr.getBlockPos());
            Vec3 renderView = event.getCamera().getPosition();
            transform.pushPose();
            transform.translate(-renderView.x, -renderView.y, -renderView.z);
            transform.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            BlockEntity tile = living.level().getBlockEntity(rtr.getBlockPos());
            ItemStack stack = living.getItemInHand(InteractionHand.MAIN_HAND);
            if (tile instanceof TurntableBlockEntity) {
                TurntableBlockEntity turntableTile = (TurntableBlockEntity)tile;
                if (Utils.isHammer(stack)) {
                    Direction side = rtr.getDirection();
                    Direction facing = turntableTile.getFacing();
                    if (side.getAxis() != facing.getAxis()) {
                        transform.pushPose();
                        transform.translate(0.5, 0.5, 0.5);
                        transform.pushTransformation(ClientUtils.toModelRotation(side).getRotation());
                        transform.mulPose(new Quaternionf().rotateXYZ(-1.5707964f, 0.0f, 0.0f));
                        Rotation rotation = turntableTile.getRotationFromSide(side);
                        boolean cw180 = rotation == Rotation.CLOCKWISE_180;
                        double angle = cw180 ? (double)(living.tickCount % 40) / 20.0 : (double)(living.tickCount % 80) / 40.0;
                        double stepDistance = (double)(cw180 ? 2 : 4) * Math.PI;
                        angle = -(angle - Math.sin(angle * stepDistance) / stepDistance) * Math.PI;
                        BlockOverlayUtils.drawCircularRotationArrows(buffer, transform, (float)angle, rotation == Rotation.COUNTERCLOCKWISE_90, cw180);
                        transform.popPose();
                        transform.popPose();
                    }
                }
            }
            if (!stack.isEmpty() && ConveyorHandler.isConveyorBlock(Block.byItem((Item)stack.getItem())) && rtr.getDirection().getAxis() == Direction.Axis.Y) {
                Direction side = rtr.getDirection();
                shape = world.getBlockState(pos).getBlockSupportShape((BlockGetter)world, pos);
                AABB targetedBB = null;
                if (!shape.isEmpty()) {
                    targetedBB = shape.bounds();
                }
                BlockOverlayUtils.drawQuadrantX(transform, buffer, side, targetedBB, 0.002f);
                float xFromMid = side.getAxis() == Direction.Axis.X ? 0.0f : (float)rtr.getLocation().x - (float)pos.getX() - 0.5f;
                float yFromMid = side.getAxis() == Direction.Axis.Y ? 0.0f : (float)rtr.getLocation().y - (float)pos.getY() - 0.5f;
                float zFromMid = side.getAxis() == Direction.Axis.Z ? 0.0f : (float)rtr.getLocation().z - (float)pos.getZ() - 0.5f;
                float max = Math.max(Math.abs(yFromMid), Math.max(Math.abs(xFromMid), Math.abs(zFromMid)));
                Vec3 dir = new Vec3(max == Math.abs(xFromMid) ? (double)Math.signum(xFromMid) : 0.0, max == Math.abs(yFromMid) ? (double)Math.signum(yFromMid) : 0.0, max == Math.abs(zFromMid) ? (double)Math.signum(zFromMid) : 0.0);
                BlockOverlayUtils.drawBlockOverlayArrow(transform.last(), buffer, dir, side, targetedBB);
            }
            if (targetBlock.getBlock() instanceof CatwalkBlock && Utils.isHammer(stack) && rtr.getDirection() == Direction.UP && living.isShiftKeyDown()) {
                AABB targetedBB = new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
                BlockOverlayUtils.drawQuadrantX(transform, buffer, Direction.UP, targetedBB, 0.002f);
            }
            transform.popPose();
            if (targetBlock.getBlock() instanceof WindowBlock) {
                ((WorldRendererAccess)event.getLevelRenderer()).callRenderHitOutline(transform, buffer.getBuffer(IERenderTypes.LINES_NONTRANSLUCENT), (Entity)living, renderView.x, renderView.y, renderView.z, pos, targetBlock);
                event.setCanceled(true);
            }
            if ((shape = stack.getItem()) instanceof DrillItem && (drillItem = (DrillItem)shape).isEffective(stack, targetBlock) && !(head = drillItem.getHead(stack)).isEmpty() && living instanceof Player) {
                Player player = (Player)living;
                if (!living.isShiftKeyDown() && !DrillItem.isSingleBlockMode(stack)) {
                    ImmutableList<BlockPos> potentialBlocks = ((IDrillHead)head.getItem()).getExtraBlocksDug(head, world, player, (HitResult)event.getTarget());
                    ArrayList<BlockPos> breakingBlocks = new ArrayList<BlockPos>();
                    for (BlockPos candidate : potentialBlocks) {
                        BlockState targetState;
                        if (!drillItem.canBreakExtraBlock(world, candidate, targetState = world.getBlockState(candidate), player, stack, head)) continue;
                        breakingBlocks.add(candidate);
                    }
                    BlockOverlayUtils.drawAdditionalBlockbreak(event, player, breakingBlocks);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getEntity().getPersistentData().contains("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), false);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.getEntity().getPersistentData().contains("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), true);
        }
    }

    private static void enableHead(LivingEntityRenderer renderer, boolean shouldEnable) {
        EntityModel m = renderer.getModel();
        if (m instanceof HeadedModel) {
            ((HeadedModel)m).getHead().visible = shouldEnable;
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinLevelEvent event) {
        if (event.getEntity().level().isClientSide && event.getEntity() instanceof AbstractMinecart) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageMinecartShaderSync(event.getEntity())});
        }
    }
}

