/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.joml.Quaternionf;

public class ItemOverlayUtils {
    public static VertexConsumer getHudElementsBuilder(MultiBufferSource.BufferSource buffer) {
        return buffer.getBuffer(IERenderTypes.getGui(ImmersiveEngineering.rl("textures/gui/hud_elements.png")));
    }

    public static void renderRevolverOverlay(MultiBufferSource.BufferSource buffer, GuiGraphics graphics, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        NonNullList<ItemStack> bullets = ((IEItemInterfaces.IBulletContainer)equipped.getItem()).getBullets(equipped);
        if (bullets != null) {
            int bulletAmount = ((IEItemInterfaces.IBulletContainer)equipped.getItem()).getBulletCount(equipped);
            HumanoidArm side = ItemUtils.getLivingHand((LivingEntity)player, hand);
            boolean right = side == HumanoidArm.RIGHT;
            float dx = right ? (float)(scaledWidth - 32 - 48) : 48.0f;
            float dy = scaledHeight - 64;
            PoseStack transform = graphics.pose();
            transform.pushPose();
            transform.translate(dx, dy, 0.0f);
            transform.scale(0.5f, 0.5f, 1.0f);
            RevolverScreen.drawExternalGUI(bullets, bulletAmount, graphics);
            transform.popPose();
        }
    }

    public static void renderRailgunOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        int duration = 72000 - (player.isUsingItem() && player.getUsedItemHand() == hand ? player.getUseItemRemainingTicks() : 0);
        RailgunItem cfr_ignored_0 = (RailgunItem)equipped.getItem();
        int chargeTime = RailgunItem.getChargeTime(equipped);
        int chargeLevel = duration < 72000 ? Math.min(99, (int)((float)duration / (float)chargeTime * 100.0f)) : 0;
        float scale = 1.5f;
        VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
        boolean boundLeft = player.getMainArm() == HumanoidArm.RIGHT == (hand == InteractionHand.OFF_HAND);
        float dx = boundLeft ? 24.0f : (float)(scaledWidth - 24 - 64);
        float dy = scaledHeight - 16;
        transform.pushPose();
        transform.translate(dx, dy, 0.0f);
        GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, -32.0f, 64.0f, 32.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.375f, 0.5f);
        ItemStack ammo = RailgunItem.findAmmo(equipped, player);
        if (!ammo.isEmpty()) {
            GuiHelper.renderItemWithOverlayIntoGUI((MultiBufferSource)buffer, transform, ammo, 6, -22, player.level());
        }
        transform.translate(30.0, -27.5, 0.0);
        transform.scale(scale, scale, 1.0f);
        String chargeTxt = chargeLevel < 10 ? "0 " + chargeLevel : chargeLevel / 10 + " " + chargeLevel % 10;
        ClientUtils.font().drawInBatch(chargeTxt, 0.0f, 0.0f, -557004, true, transform.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        transform.popPose();
    }

    public static void renderFluidTankOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped, boolean renderFluidUse, BiConsumer<VertexConsumer, IFluidHandlerItem> additionalRender) {
        VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
        float dx = scaledWidth - 16;
        float dy = scaledHeight;
        transform.pushPose();
        transform.translate(dx, dy, 0.0f);
        int w = 31;
        int h = 62;
        float uMin = 0.69921875f;
        float uMax = 0.8203125f;
        float vMin = 0.03515625f;
        float vMax = 0.27734375f;
        GuiHelper.drawTexturedColoredRect(builder, transform, -24.0f, -68.0f, w, h, 1.0f, 1.0f, 1.0f, 1.0f, uMin, uMax, vMin, vMax);
        transform.translate(-23.0f, -37.0f, 0.0f);
        IFluidHandlerItem handler = (IFluidHandlerItem)equipped.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            int capacity = -1;
            if (handler.getTanks() > 0) {
                capacity = handler.getTankCapacity(0);
            }
            if (capacity > 0) {
                FluidStack fuel = handler.getFluidInTank(0);
                int amount = fuel.getAmount();
                if (renderFluidUse && player.isUsingItem() && player.getUsedItemHand() == hand) {
                    int use = player.getTicksUsingItem();
                    amount -= use * (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
                }
                float cap = capacity;
                float angle = 83.0f - (float)(166 * amount) / cap;
                transform.pushPose();
                transform.mulPose(new Quaternionf().rotateZ(angle * ((float)Math.PI / 180)));
                GuiHelper.drawTexturedColoredRect(builder, transform, 6.0f, -2.0f, 24.0f, 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.35546875f, 0.48046875f, 0.3125f, 0.33984375f);
                transform.popPose();
                transform.translate(23.0f, 37.0f, 0.0f);
                additionalRender.accept(builder, handler);
            }
        }
        transform.popPose();
    }

    public static void renderDrillOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            GuiHelper.drawTexturedColoredRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
            ItemStack head = ((DrillItem)equipped.getItem()).getHead(equipped);
            if (!head.isEmpty()) {
                GuiHelper.renderItemWithOverlayIntoGUI((MultiBufferSource)buffer, transform, head, -51, -45, player.level());
            }
        });
    }

    public static void renderBuzzsawOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, false, (builder, handler) -> {
            GuiHelper.drawTexturedColoredRect(builder, transform, -54.0f, -73.0f, 66.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.421875f, 0.6796875f, 0.015625f, 0.296875f);
            ItemStack blade = ((BuzzsawItem)equipped.getItem()).getHead(equipped);
            if (!blade.isEmpty()) {
                GuiHelper.renderItemWithOverlayIntoGUI((MultiBufferSource)buffer, transform, blade, -51, -45, player.level());
            }
        });
    }

    public static void renderChemthrowerOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        ItemOverlayUtils.renderFluidTankOverlay(buffer, transform, scaledWidth, scaledHeight, player, hand, equipped, true, (builder, handler) -> {
            GuiHelper.drawTexturedColoredRect(builder, transform, -41.0f, -73.0f, 53.0f, 72.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.03125f, 0.23828125f, 0.015625f, 0.296875f);
            boolean ignite = ChemthrowerItem.isIgniteEnable(equipped);
            GuiHelper.drawTexturedColoredRect(builder, transform, -32.0f, -43.0f, 12.0f, 12.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2578125f, 0.3046875f, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
            GuiHelper.drawTexturedColoredRect(builder, transform, -100.0f, -20.0f, 64.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.296875f, 0.359375f);
            FluidStack fuel = handler.getFluidInTank(0);
            if (!fuel.isEmpty()) {
                String name = ClientUtils.font().substrByWidth((FormattedText)fuel.getDisplayName(), 50).getString().trim();
                ClientUtils.font().drawInBatch(name, (float)(-68 - ClientUtils.font().width(name) / 2), -15.0f, 0, false, transform.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        });
    }

    public static void renderShieldOverlay(MultiBufferSource.BufferSource buffer, PoseStack transform, int scaledWidth, int scaledHeight, Player player, InteractionHand hand, ItemStack equipped) {
        CompoundTag upgrades = ((IEShieldItem)equipped.getItem()).getUpgrades(equipped);
        if (!upgrades.isEmpty()) {
            float h;
            VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder(buffer);
            boolean boundLeft = player.getMainArm() == HumanoidArm.RIGHT == (hand == InteractionHand.OFF_HAND);
            float dx = boundLeft ? 16.0f : (float)(scaledWidth - 16 - 64);
            float dy = scaledHeight;
            transform.pushPose();
            transform.translate(dx, dy, 0.0f);
            GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, -22.0f, 64.0f, 22.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.25f, 0.6875f, 0.7734375f);
            if (upgrades.getBoolean("flash")) {
                GuiHelper.drawTexturedColoredRect(builder, transform, 11.0f, -38.0f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, 0.625f, 0.6875f);
                if (upgrades.contains("flash_cooldown")) {
                    h = (float)upgrades.getInt("flash_cooldown") / 40.0f * 16.0f;
                    GuiHelper.drawTexturedColoredRect(builder, transform, 11.0f, -22.0f - h, 16.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.04296875f, 0.10546875f, (214.0f - h) / 256.0f, 0.8359375f);
                }
            }
            if (upgrades.getBoolean("shock")) {
                GuiHelper.drawTexturedColoredRect(builder, transform, 40.0f, -38.0f, 12.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, 0.625f, 0.6875f);
                if (upgrades.contains("shock_cooldown")) {
                    h = (float)upgrades.getInt("shock_cooldown") / 40.0f * 16.0f;
                    GuiHelper.drawTexturedColoredRect(builder, transform, 40.0f, -22.0f - h, 12.0f, h, 1.0f, 1.0f, 1.0f, 1.0f, 0.15625f, 0.203125f, (214.0f - h) / 256.0f, 0.8359375f);
                }
            }
            transform.popPose();
        }
    }
}

