/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.common.register.IEParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public record FluidSplashOptions(Fluid fluid) implements ParticleOptions
{
    public static final Codec<FluidSplashOptions> CODEC = ResourceLocation.CODEC.xmap(FluidSplashOptions::new, d -> BuiltInRegistries.FLUID.getKey((Object)d.fluid));

    public FluidSplashOptions(ResourceLocation name) {
        this((Fluid)BuiltInRegistries.FLUID.get(name));
    }

    @Nonnull
    public ParticleType<?> getType() {
        return (ParticleType)IEParticles.FLUID_SPLASH.get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(BuiltInRegistries.FLUID.getKey((Object)this.fluid));
    }

    @Nonnull
    public String writeToString() {
        return BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString();
    }

    public static class DataDeserializer
    implements ParticleOptions.Deserializer<FluidSplashOptions> {
        @Nonnull
        public FluidSplashOptions fromCommand(@Nonnull ParticleType<FluidSplashOptions> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            String name = reader.getString();
            return new FluidSplashOptions(new ResourceLocation(name));
        }

        @Nonnull
        public FluidSplashOptions fromNetwork(@Nonnull ParticleType<FluidSplashOptions> particleTypeIn, FriendlyByteBuf buffer) {
            return new FluidSplashOptions(buffer.readResourceLocation());
        }
    }
}

