/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.gui.ArcFurnaceMenu;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public class ArcFurnaceScreen
extends IEContainerScreen<ArcFurnaceMenu> {
    private static final ResourceLocation TEXTURE = ArcFurnaceScreen.makeTextureLocation("arc_furnace");
    private GuiButtonIE distributeButton;
    private static final DecimalFormat PROGRESS_PERCENTAGE = new DecimalFormat(" #00%");

    public ArcFurnaceScreen(ArcFurnaceMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 207;
        this.inventoryLabelY = 116;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 157, this.topPos + 22, ((ArcFurnaceMenu)this.menu).energy));
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (this.distributeButton.isHovered() && ((ArcFurnaceMenu)this.menu).getCarried().isEmpty()) {
            addLine.accept((Component)Component.translatable((String)"gui.immersiveengineering.config.arcfurnace.distribute"));
        }
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        for (ArcFurnaceMenu.ProcessSlot process : ((ArcFurnaceMenu)this.menu).processes.get()) {
            int slot = process.slot();
            int h = process.processStep();
            graphics.blit(this.background, this.leftPos + 27 + slot % 3 * 21, this.topPos + 34 + slot / 3 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List ret = super.getTooltipFromContainerItem(stack);
        if (this.hoveredSlot != null) {
            ((ArcFurnaceMenu)this.menu).processes.get().forEach(processSlot -> {
                if (processSlot.slot() == this.hoveredSlot.index) {
                    MutableComponent progress = Component.literal((String)PROGRESS_PERCENTAGE.format(processSlot.processFloat())).withStyle(ChatFormatting.GRAY);
                    Object patt2963$temp = ret.get(0);
                    if (patt2963$temp instanceof MutableComponent) {
                        MutableComponent mutable = (MutableComponent)patt2963$temp;
                        mutable.append((Component)progress);
                    } else {
                        ret.add(progress);
                    }
                }
            });
        }
        return ret;
    }

    @Override
    public void init() {
        super.init();
        this.distributeButton = new GuiButtonIE(this.leftPos + 10, this.topPos + 10, 16, 16, (Component)Component.empty(), TEXTURE, 179, 0, btn -> {
            if (((ArcFurnaceMenu)this.menu).getCarried().isEmpty()) {
                this.autoSplitStacks();
            }
        }){

            public boolean isHoveredOrFocused() {
                return super.isHoveredOrFocused() && ((ArcFurnaceMenu)ArcFurnaceScreen.this.menu).getCarried().isEmpty();
            }
        }.setHoverOffset(0, 16);
        this.addRenderableWidget((GuiEventListener)this.distributeButton);
    }

    private void autoSplitStacks() {
        for (int j = 0; j < 12; ++j) {
            int emptySlot = -1;
            int largestSlot = -1;
            int largestCount = -1;
            for (int i = 0; i < 12; ++i) {
                if (((ArcFurnaceMenu)this.menu).getSlot(i).hasItem()) {
                    int count = ((ArcFurnaceMenu)this.menu).getSlot(i).getItem().getCount();
                    if (count <= 1 || count <= largestCount) continue;
                    largestSlot = i;
                    largestCount = count;
                    continue;
                }
                if (emptySlot >= 0) continue;
                emptySlot = i;
            }
            if (emptySlot < 0 || largestSlot < 0) break;
            this.slotClicked(((ArcFurnaceMenu)this.menu).getSlot(largestSlot), largestSlot, 1, ClickType.PICKUP);
            this.slotClicked(((ArcFurnaceMenu)this.menu).getSlot(emptySlot), emptySlot, 0, ClickType.PICKUP);
        }
    }
}

