/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.network.MessageContainerUpdate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class IEContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C> {
    private final ResettableLazy<List<InfoArea>> infoAreas;
    protected final ResourceLocation background;

    public IEContainerScreen(C inventorySlotsIn, Inventory inv, Component title, ResourceLocation background) {
        super(inventorySlotsIn, inv, title);
        this.background = background;
        this.infoAreas = new ResettableLazy(this::makeInfoAreas);
    }

    protected void init() {
        super.init();
        this.infoAreas.reset();
        this.inventoryLabelY = this.imageHeight - 91;
    }

    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -557004, true);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -557004, true);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (InfoArea area : this.infoAreas.get()) {
            area.fillTooltip(mouseX, mouseY, tooltip);
        }
        for (GuiEventListener w : this.children()) {
            if (!w.isMouseOver((double)mouseX, (double)mouseY) || !(w instanceof ITooltipWidget)) continue;
            ITooltipWidget ttw = (ITooltipWidget)w;
            ttw.gatherTooltip(mouseX, mouseY, tooltip);
        }
        this.gatherAdditionalTooltips(mouseX, mouseY, tooltip::add, t -> tooltip.add((Component)TextUtils.applyFormat(t, ChatFormatting.GRAY)));
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            this.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    protected boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.leftPos + x && mouseY >= this.topPos + y && mouseX < this.leftPos + x + w && mouseY < this.topPos + y + h;
    }

    public void fullInit() {
        super.init(this.minecraft, this.width, this.height);
    }

    protected final void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawBackgroundTexture(graphics);
        this.drawContainerBackgroundPre(graphics, partialTicks, x, y);
        for (InfoArea area : this.infoAreas.get()) {
            area.draw(graphics);
        }
    }

    protected void drawBackgroundTexture(GuiGraphics graphics) {
        graphics.blit(this.background, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
    }

    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
    }

    public static ResourceLocation makeTextureLocation(String name) {
        return ImmersiveEngineering.rl("textures/gui/" + name + ".png");
    }

    protected void sendUpdateToServer(CompoundTag message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageContainerUpdate(this.menu.containerId, message)});
    }
}

