/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonDyeColor;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherBlockEntity;
import blusunrize.immersiveengineering.common.gui.ItemBatcherMenu;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;

public class ItemBatcherScreen
extends IEContainerScreen<ItemBatcherMenu> {
    private static final ResourceLocation TEXTURE = ItemBatcherScreen.makeTextureLocation("item_batcher");

    public ItemBatcherScreen(ItemBatcherMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 199;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)new GuiButtonState<ItemBatcherBlockEntity.BatchMode>(this.leftPos + 7, this.topPos + 92, 18, 18, (Component)Component.empty(), ItemBatcherBlockEntity.BatchMode.values(), ((ItemBatcherMenu)this.menu).batchMode::get, TEXTURE, 176, 36, 1, btn -> {
            CompoundTag tag = new CompoundTag();
            int newMode = ((ItemBatcherBlockEntity.BatchMode)((Object)((Object)btn.getNextState()))).ordinal();
            tag.putByte("batchMode", (byte)newMode);
            this.handleButtonClick(tag);
        }, ItemBatcherScreen::gatherBatchmodeTooltip));
        for (int slot = 0; slot < 9; ++slot) {
            int finalSlot = slot;
            GetterAndSetter<Integer> color = ((ItemBatcherMenu)this.menu).colors.get(slot);
            this.addRenderableWidget((GuiEventListener)new GuiButtonDyeColor(this.leftPos + 12 + slot * 18, this.topPos + 77, "", color::get, btn -> {
                CompoundTag tag = new CompoundTag();
                int newState = ((DyeColor)btn.getNextState()).getId();
                tag.putInt("redstoneColor_slot", finalSlot);
                tag.putInt("redstoneColor_val", newState);
                this.handleButtonClick(tag);
            }, ItemBatcherScreen::gatherRedstoneTooltip));
        }
    }

    protected void handleButtonClick(CompoundTag nbt) {
        if (!nbt.isEmpty()) {
            this.sendUpdateToServer(nbt);
            this.init();
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, I18n.get((String)"block.immersiveengineering.item_batcher", (Object[])new Object[0]), 8, 6, -557004, true);
        graphics.drawString(this.font, I18n.get((String)"gui.immersiveengineering.config.item_batcher.filter", (Object[])new Object[0]), 8, 20, 0xE0E0E0);
        graphics.drawString(this.font, I18n.get((String)"gui.immersiveengineering.config.item_batcher.buffer", (Object[])new Object[0]), 8, 49, 0xE0E0E0);
    }

    private static void gatherBatchmodeTooltip(List<Component> out, ItemBatcherBlockEntity.BatchMode mode) {
        out.add((Component)Component.translatable((String)"gui.immersiveengineering.config.item_batcher.batchmode"));
        out.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)("gui.immersiveengineering.config.item_batcher.batchmode." + mode.name())), ChatFormatting.GRAY));
    }

    public static void gatherRedstoneTooltip(List<Component> out, DyeColor color) {
        out.add((Component)Component.translatable((String)"gui.immersiveengineering.config.item_batcher.redstone_color"));
        out.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)("color.minecraft." + color.getName())), ChatFormatting.GRAY));
    }
}

