/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;

public class RedstoneConnectorScreen
extends ClientBlockEntityScreen<ConnectorRedstoneBlockEntity> {
    private static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("redstone_configuration");
    private GuiButtonState<IEEnums.IOSideConfig> buttonInOut;
    private GuiButtonBoolean[] colorButtons;

    public RedstoneConnectorScreen(ConnectorRedstoneBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 100;
        this.ySize = 120;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.buttonInOut = new GuiButtonState<IEEnums.IOSideConfig>(this.guiLeft + 41, this.guiTop + 20, 18, 18, (Component)Component.empty(), new IEEnums.IOSideConfig[]{IEEnums.IOSideConfig.INPUT, IEEnums.IOSideConfig.OUTPUT}, () -> ((ConnectorRedstoneBlockEntity)this.blockEntity).ioMode.ordinal() - 1, TEXTURE, 176, 0, 1, btn -> this.sendConfig("ioMode", ((IEEnums.IOSideConfig)((Object)((Object)btn.getNextState()))).ordinal()));
        this.addRenderableWidget((GuiEventListener)this.buttonInOut);
        this.colorButtons = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtons.length; ++i) {
            DyeColor color = DyeColor.byId((int)i);
            this.colorButtons[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtons, this.guiLeft + 22 + i % 4 * 14, this.guiTop + 44 + i / 4 * 14, () -> ((ConnectorRedstoneBlockEntity)this.blockEntity).redstoneChannel == color, color, btn -> this.sendConfig("redstoneChannel", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtons[i]);
        }
    }

    public void sendConfig(String key, int value) {
        CompoundTag message = new CompoundTag();
        message.putInt(key, value);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageBlockEntitySync((IEBaseBlockEntity)this.blockEntity, message)});
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        if (this.buttonInOut.isHovered()) {
            tooltip.add(Component.translatable((String)"gui.immersiveengineering.config.redstone_iomode"));
            tooltip.add(TextUtils.applyFormat(this.buttonInOut.getState().getTextComponent(), ChatFormatting.GRAY));
        }
        for (int i = 0; i < this.colorButtons.length; ++i) {
            if (!this.colorButtons[i].isHovered()) continue;
            tooltip.add(Component.translatable((String)"gui.immersiveengineering.config.redstone_color"));
            tooltip.add(TextUtils.applyFormat((Component)Component.translatable((String)("color.minecraft." + DyeColor.byId((int)i).getName())), ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (ClientUtils.mc().options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public static GuiButtonBoolean buildColorButton(GuiButtonBoolean[] buttons, int posX, int posY, Supplier<Boolean> active, final DyeColor color, Consumer<GuiButtonBoolean> onClick) {
        return new GuiButtonBoolean(posX, posY, 12, 12, (Component)Component.empty(), active, TEXTURE, 194, 0, 1, btn -> {
            if (((Boolean)btn.getNextState()).booleanValue()) {
                onClick.accept((GuiButtonBoolean)btn);
            }
            for (int j = 0; j < buttons.length; ++j) {
                if (j == color.ordinal() || !((Boolean)buttons[j].getState()).booleanValue()) continue;
                buttons[j].onClick(buttons[j].getX(), buttons[j].getY());
            }
        }){

            protected boolean isValidClickButton(int button) {
                return button == 0 && (Boolean)this.getState() == false;
            }

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
                int col = color.getTextColor();
                if (!((Boolean)this.getState()).booleanValue()) {
                    col = ClientUtils.getDarkenedTextColour(col);
                }
                col = 0xFF000000 | col;
                graphics.fillGradient(this.getX() + 3, this.getY() + 3, this.getX() + 9, this.getY() + 9, col, col);
            }
        };
    }
}

