/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.RedstoneConnectorScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiSliderIE;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorProbeBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;

public class RedstoneProbeScreen
extends ClientBlockEntityScreen<ConnectorProbeBlockEntity> {
    private GuiButtonBoolean[] colorButtonsSend;
    private GuiButtonBoolean[] colorButtonsReceive;

    public RedstoneProbeScreen(ConnectorProbeBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 216;
        this.ySize = 80;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.colorButtonsSend = new GuiButtonBoolean[16];
        this.colorButtonsReceive = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtonsSend.length; ++i) {
            DyeColor color = DyeColor.byId((int)i);
            this.colorButtonsSend[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsSend, this.guiLeft + 20 + i % 4 * 14, this.guiTop + 28 + i / 4 * 14, () -> ((ConnectorProbeBlockEntity)this.blockEntity).redstoneChannelSending == color, color, btn -> this.sendConfig("redstoneChannelSending", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsSend[i]);
            this.colorButtonsReceive[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsReceive, this.guiLeft + 136 + i % 4 * 14, this.guiTop + 28 + i / 4 * 14, () -> ((ConnectorProbeBlockEntity)this.blockEntity).redstoneChannel == color, color, btn -> this.sendConfig("redstoneChannel", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsReceive[i]);
        }
        this.addRenderableWidget((GuiEventListener)new GuiSliderIE(this.guiLeft + 15, this.guiTop, 64, (Component)Component.translatable((String)"gui.immersiveengineering.config.output_threshold"), 0, 15, ((ConnectorProbeBlockEntity)this.blockEntity).outputThreshold, value -> this.sendConfig("outputThreshold", Math.round(value * 15.0f))));
    }

    private void sendConfig(String key, int value) {
        CompoundTag message = new CompoundTag();
        message.putInt(key, value);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageBlockEntitySync((IEBaseBlockEntity)this.blockEntity, message)});
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_sending").getString(), this.guiLeft, this.guiTop + 18, DyeColor.WHITE.getTextColor());
        graphics.drawString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_receiving").getString(), this.guiLeft + 116, this.guiTop + 18, DyeColor.WHITE.getTextColor());
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        for (int i = 0; i < this.colorButtonsSend.length; ++i) {
            if (!this.colorButtonsSend[i].isHovered() && !this.colorButtonsReceive[i].isHovered()) continue;
            tooltip.add(Component.translatable((String)"gui.immersiveengineering.config.redstone_color"));
            tooltip.add(TextUtils.applyFormat((Component)Component.translatable((String)("color.minecraft." + DyeColor.byId((int)i).getName())), ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

