/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.RedstoneConnectorScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RedstoneStateCellBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;

public class RedstoneStateCellScreen
extends ClientBlockEntityScreen<RedstoneStateCellBlockEntity> {
    private GuiButtonBoolean[] colorButtonsSet;
    private GuiButtonBoolean[] colorButtonsReset;
    private GuiButtonBoolean[] colorButtonsOut;

    public RedstoneStateCellScreen(RedstoneStateCellBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 216;
        this.ySize = 80;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.colorButtonsSet = new GuiButtonBoolean[16];
        this.colorButtonsReset = new GuiButtonBoolean[16];
        this.colorButtonsOut = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtonsSet.length; ++i) {
            DyeColor color = DyeColor.byId((int)i);
            this.colorButtonsSet[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsSet, this.guiLeft + i % 4 * 14, this.guiTop + 12 + i / 4 * 14, () -> ((RedstoneStateCellBlockEntity)this.blockEntity).redstoneChannelSet == color, color, btn -> this.sendConfig("redstoneChannelSet", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsSet[i]);
            this.colorButtonsReset[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsReset, this.guiLeft + 120 + i % 4 * 14, this.guiTop + 12 + i / 4 * 14, () -> ((RedstoneStateCellBlockEntity)this.blockEntity).redstoneChannelReset == color, color, btn -> this.sendConfig("redstoneChannelReset", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsReset[i]);
            this.colorButtonsOut[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsOut, this.guiLeft + 60 + i % 4 * 14, this.guiTop + 88 + i / 4 * 14, () -> ((RedstoneStateCellBlockEntity)this.blockEntity).redstoneChannel == color, color, btn -> this.sendConfig("redstoneChannel", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsOut[i]);
        }
    }

    private void sendConfig(String key, int value) {
        CompoundTag message = new CompoundTag();
        message.putInt(key, value);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageBlockEntitySync((IEBaseBlockEntity)this.blockEntity, message)});
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawCenteredString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_set").getString(), this.guiLeft + 20, this.guiTop, DyeColor.WHITE.getTextColor());
        graphics.drawCenteredString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_reset").getString(), this.guiLeft + 156, this.guiTop, DyeColor.WHITE.getTextColor());
        graphics.drawCenteredString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_output").getString(), this.guiLeft + 88, this.guiTop + 76, DyeColor.WHITE.getTextColor());
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        for (int i = 0; i < this.colorButtonsSet.length; ++i) {
            if (!this.colorButtonsSet[i].isHovered() && !this.colorButtonsReset[i].isHovered() && !this.colorButtonsOut[i].isHovered()) continue;
            tooltip.add(Component.translatable((String)"gui.immersiveengineering.config.redstone_color"));
            tooltip.add(TextUtils.applyFormat((Component)Component.translatable((String)("color.minecraft." + DyeColor.byId((int)i).getName())), ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

