/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.RedstoneConnectorScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiSliderIE;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.RedstoneTimerBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.PacketDistributor;

public class RedstoneTimerScreen
extends ClientBlockEntityScreen<RedstoneTimerBlockEntity> {
    private GuiButtonBoolean[] colorButtonsOutput;
    private GuiButtonBoolean[] colorButtonsControl;

    public RedstoneTimerScreen(RedstoneTimerBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 216;
        this.ySize = 80;
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.colorButtonsOutput = new GuiButtonBoolean[16];
        this.colorButtonsControl = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtonsOutput.length; ++i) {
            DyeColor color = DyeColor.byId((int)i);
            this.colorButtonsOutput[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsOutput, this.guiLeft + 20 + i % 4 * 14, this.guiTop + 28 + i / 4 * 14, () -> ((RedstoneTimerBlockEntity)this.blockEntity).redstoneChannel == color, color, btn -> this.sendConfig("redstoneChannel", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsOutput[i]);
            this.colorButtonsControl[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtonsControl, this.guiLeft + 136 + i % 4 * 14, this.guiTop + 28 + i / 4 * 14, () -> ((RedstoneTimerBlockEntity)this.blockEntity).redstoneChannelControl == color, color, btn -> this.sendConfig("redstoneChannelControl", color.getId()));
            this.addRenderableWidget((GuiEventListener)this.colorButtonsControl[i]);
        }
        this.addRenderableWidget((GuiEventListener)new GuiButtonCheckbox(this.guiLeft + 106, this.guiTop + 84, (Component)Component.translatable((String)"gui.immersiveengineering.config.redstone_require_control_signal"), () -> ((RedstoneTimerBlockEntity)this.blockEntity).requireControlSignal, btn -> this.sendConfig("requireControlSignal", (Boolean)btn.getNextState())));
        this.addRenderableWidget((GuiEventListener)new TimerSlider(this.guiLeft + 15, this.guiTop, 176, 8, 200, ((RedstoneTimerBlockEntity)this.blockEntity).timerSetting, value -> this.sendConfig("timerSetting", 8 + Math.round(value * 192.0f))));
    }

    private void sendConfig(String key, int value) {
        CompoundTag message = new CompoundTag();
        message.putInt(key, value);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageBlockEntitySync((IEBaseBlockEntity)this.blockEntity, message)});
    }

    private void sendConfig(String key, boolean value) {
        CompoundTag message = new CompoundTag();
        message.putBoolean(key, value);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new MessageBlockEntitySync((IEBaseBlockEntity)this.blockEntity, message)});
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_output").getString(), this.guiLeft, this.guiTop + 18, DyeColor.WHITE.getTextColor());
        graphics.drawString(this.font, Component.translatable((String)"gui.immersiveengineering.config.redstone_color_control").getString(), this.guiLeft + 116, this.guiTop + 18, DyeColor.WHITE.getTextColor());
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        for (int i = 0; i < this.colorButtonsOutput.length; ++i) {
            if (!this.colorButtonsOutput[i].isHovered() && !this.colorButtonsControl[i].isHovered()) continue;
            tooltip.add(Component.translatable((String)"gui.immersiveengineering.config.redstone_color"));
            tooltip.add(TextUtils.applyFormat((Component)Component.translatable((String)("color.minecraft." + DyeColor.byId((int)i).getName())), ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private static class TimerSlider
    extends GuiSliderIE {
        public TimerSlider(int x, int y, int width, int min, int max, int value, FloatConsumer handler) {
            super(x, y, width, (Component)Component.empty(), min, max, value, handler);
        }

        protected void updateMessage() {
            this.setMessage(RedstoneTimerBlockEntity.getTimeFormatted(this.getValueInt()));
        }
    }
}

