/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.common.gui.SorterMenu;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SorterScreen
extends IEContainerScreen<SorterMenu> {
    private static final ResourceLocation TEXTURE = SorterScreen.makeTextureLocation("sorter");

    public SorterScreen(SorterMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 244;
        this.inventoryLabelY = this.imageHeight - 91;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        for (int side = 0; side < 6; ++side) {
            int x = this.leftPos + 30 + side / 2 * 58;
            int y = this.topPos + 44 + side % 2 * 76;
            String s = I18n.get((String)("desc.immersiveengineering.info.blockSide." + Direction.from3DDataValue((int)side)), (Object[])new Object[0]).substring(0, 1);
            RenderSystem.enableBlend();
            graphics.drawString(ClientUtils.font(), s, x - ClientUtils.font().width(s) / 2, y, -1429418804, true);
        }
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        for (int side = 0; side < 6; ++side) {
            for (FilterBit bit : FilterBit.values()) {
                int x = this.leftPos + 3 + side / 2 * 58 + bit.ordinal() * 18;
                int y = this.topPos + 3 + side % 2 * 76;
                int sideFinal = side;
                GetterAndSetter<Integer> value = ((SorterMenu)this.menu).filterMasks.get(side);
                ButtonSorter b = new ButtonSorter(x, y, bit, value::get, btn -> {
                    CompoundTag tag = new CompoundTag();
                    tag.putInt("sideConfigVal", (Integer)value.get() ^ bit.mask());
                    tag.putInt("sideConfigId", sideFinal);
                    this.sendUpdateToServer(tag);
                    this.fullInit();
                });
                this.addRenderableWidget((GuiEventListener)b);
            }
        }
    }

    public static enum FilterBit {
        TAG,
        NBT,
        DAMAGE;


        public String getTranslationKey() {
            return "desc.immersiveengineering.info.filter." + this.name().toLowerCase(Locale.ROOT);
        }

        public int mask() {
            return 1 << this.ordinal();
        }
    }

    public static class ButtonSorter
    extends Button
    implements ITooltipWidget {
        private final FilterBit type;
        private final IntSupplier state;

        public ButtonSorter(int x, int y, FilterBit type, IntSupplier state, Button.OnPress handler) {
            super(x, y, 18, 18, (Component)Component.empty(), handler, DEFAULT_NARRATION);
            this.type = type;
            this.state = state;
        }

        public void renderWidget(GuiGraphics graphics, int mx, int my, float partialTicks) {
            if (this.visible) {
                ClientUtils.bindTexture(TEXTURE);
                this.isHovered = mx >= this.getX() && my >= this.getY() && mx < this.getX() + this.width && my < this.getY() + this.height;
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                boolean active = (this.state.getAsInt() & this.type.mask()) != 0;
                graphics.blit(TEXTURE, this.getX(), this.getY(), 176 + this.type.ordinal() * 18, active ? 3 : 21, this.width, this.height);
            }
        }

        @Override
        public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
            String[] split = I18n.get((String)this.type.getTranslationKey(), (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    tooltip.add((Component)Component.literal((String)split[i]));
                    continue;
                }
                tooltip.add((Component)TextUtils.applyFormat((Component)Component.literal((String)split[i]), ChatFormatting.GRAY));
            }
        }
    }
}

