/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiReactiveList;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.gui.TurretMenu;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class TurretScreen<C extends TurretMenu>
extends IEContainerScreen<C> {
    protected static final ResourceLocation TEXTURE = TurretScreen.makeTextureLocation("turret");
    private EditBox nameField;

    public TurretScreen(C container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 190;
        this.inventoryLabelY = 99;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 158, this.topPos + 16, ((TurretMenu)this.menu).data.energy()));
    }

    @Override
    public void init() {
        super.init();
        this.nameField = new EditBox(this.font, this.leftPos + 11, this.topPos + 88, 58, 12, (Component)Component.empty());
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(30);
        this.addWidget((GuiEventListener)this.nameField);
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)new GuiReactiveList(this.leftPos + 10, this.topPos + 10, 60, 72, list -> {
            CompoundTag tag = new CompoundTag();
            int listOffset = -1;
            int rem = list.selectedOption;
            if (rem >= 0 && ((TurretMenu)this.menu).data.targetList().get().size() > 0) {
                tag.putInt("remove", rem);
                listOffset = list.getOffset() - 1;
                this.handleButtonClick(tag, listOffset);
            }
        }, ((TurretMenu)this.menu).data.targetList()).setPadding(0, 0, 2, 2));
        this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.leftPos + 74, this.topPos + 84, 24, 16, (Component)Component.translatable((String)"gui.immersiveengineering.config.turret.add"), TEXTURE, 176, 65, btn -> this.addName()));
        this.addRenderableWidget((GuiEventListener)new GuiButtonCheckbox(this.leftPos + 74, this.topPos + 10, (Component)Component.translatable((String)"gui.immersiveengineering.config.turret.blacklist"), () -> ((TurretMenu)this.menu).data.whitelist().get() == false, btn -> {
            CompoundTag tag = new CompoundTag();
            int listOffset = -1;
            tag.putBoolean("whitelist", ((Boolean)btn.getState()).booleanValue());
            this.handleButtonClick(tag, listOffset);
        }));
        this.addRenderableWidget((GuiEventListener)new GuiButtonCheckbox(this.leftPos + 74, this.topPos + 26, (Component)Component.translatable((String)"gui.immersiveengineering.config.turret.animals"), ((TurretMenu)this.menu).data.attackAnimals(), btn -> {
            CompoundTag tag = new CompoundTag();
            int listOffset = -1;
            tag.putBoolean("attackAnimals", ((Boolean)btn.getNextState()).booleanValue());
            this.handleButtonClick(tag, listOffset);
        }));
        this.addRenderableWidget((GuiEventListener)new GuiButtonCheckbox(this.leftPos + 74, this.topPos + 42, (Component)Component.translatable((String)"gui.immersiveengineering.config.turret.players"), ((TurretMenu)this.menu).data.attackPlayers(), btn -> {
            CompoundTag tag = new CompoundTag();
            int listOffset = -1;
            tag.putBoolean("attackPlayers", ((Boolean)btn.getNextState()).booleanValue());
            this.handleButtonClick(tag, listOffset);
        }));
        this.addRenderableWidget((GuiEventListener)new GuiButtonCheckbox(this.leftPos + 74, this.topPos + 58, (Component)Component.translatable((String)"gui.immersiveengineering.config.turret.neutrals"), ((TurretMenu)this.menu).data.attackNeutrals(), btn -> {
            CompoundTag tag = new CompoundTag();
            int listOffset = -1;
            tag.putBoolean("attackNeutrals", ((Boolean)btn.getNextState()).booleanValue());
            this.handleButtonClick(tag, listOffset);
        }));
        this.addCustomButtons();
    }

    protected abstract void addCustomButtons();

    protected void handleButtonClick(CompoundTag nbt, int listOffset) {
        if (!nbt.isEmpty()) {
            this.sendUpdateToServer(nbt);
            if (listOffset >= 0) {
                ((GuiReactiveList)((Object)this.children().get(0))).setOffset(listOffset);
            }
        }
    }

    @Override
    public void render(@Nonnull GuiGraphics graphics, int mx, int my, float partial) {
        super.render(graphics, mx, my, partial);
        this.nameField.render(graphics, mx, my, partial);
    }

    public boolean keyPressed(int key, int scancode, int p_keyPressed_3_) {
        if (this.nameField.isFocused()) {
            if (key == 257) {
                this.addName();
                return true;
            }
            if (this.nameField.keyPressed(key, scancode, p_keyPressed_3_)) {
                return true;
            }
            InputConstants.Key keyData = InputConstants.getKey((int)key, (int)scancode);
            if (this.minecraft != null && this.minecraft.options.keyInventory.isActiveAndMatches(keyData)) {
                return true;
            }
        }
        return super.keyPressed(key, scancode, p_keyPressed_3_);
    }

    private void addName() {
        CompoundTag tag = new CompoundTag();
        int listOffset = -1;
        String name = this.nameField.getValue();
        if (!((TurretMenu)this.menu).data.targetList().get().contains(name)) {
            listOffset = ((GuiReactiveList)((Object)this.children().get(0))).getMaxOffset();
            tag.putString("add", name);
        }
        this.nameField.setValue("");
        this.handleButtonClick(tag, listOffset);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return this.nameField.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean ret = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.nameField.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.nameField.setFocused(true);
            ret = true;
        }
        return ret;
    }
}

