/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiButtonState<E>
extends GuiButtonIE
implements ITooltipWidget {
    public E[] states;
    private final IntSupplier state;
    protected final int offsetDir;
    private final BiConsumer<List<Component>, E> tooltip;
    public int[] textOffset;

    public GuiButtonState(int x, int y, int w, int h, Component name, E[] states, IntSupplier state, ResourceLocation texture, int u, int v, int offsetDir, GuiButtonIE.IIEPressable<GuiButtonState<E>> handler) {
        this(x, y, w, h, name, states, state, texture, u, v, offsetDir, handler, (a, b) -> {});
    }

    public GuiButtonState(int x, int y, int w, int h, Component name, E[] states, IntSupplier state, ResourceLocation texture, int u, int v, int offsetDir, GuiButtonIE.IIEPressable<GuiButtonState<E>> handler, BiConsumer<List<Component>, E> tooltip) {
        super(x, y, w, h, name, texture, u, v, handler);
        this.states = states;
        this.state = state;
        this.offsetDir = offsetDir;
        this.tooltip = tooltip;
        this.textOffset = new int[]{this.width + 1, this.height / 2 - 3};
    }

    protected int getNextStateInt() {
        return (this.state.getAsInt() + 1) % this.states.length;
    }

    public E getNextState() {
        return this.states[this.getNextStateInt()];
    }

    public E getState() {
        return this.states[this.state.getAsInt()];
    }

    protected int getStateAsInt() {
        return this.state.getAsInt();
    }

    public int[] getTextOffset(Font fontrenderer) {
        return this.textOffset;
    }

    protected int getTextColor(boolean highlighted) {
        if (!this.active) {
            return 0xA0A0A0;
        }
        if (highlighted) {
            return -557004;
        }
        return 0xE0E0E0;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Font fontrenderer = mc.font;
        this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        int u = this.texU + (this.offsetDir == 0 ? this.width : (this.offsetDir == 2 ? -this.width : 0)) * this.state.getAsInt();
        int v = this.texV + (this.offsetDir == 1 ? this.height : (this.offsetDir == 3 ? -this.height : 0)) * this.state.getAsInt();
        graphics.blit(this.texture, this.getX(), this.getY(), u, v, this.width, this.height);
        if (!this.getMessage().getString().isEmpty()) {
            int[] offset = this.getTextOffset(fontrenderer);
            graphics.drawString(fontrenderer, this.getMessage(), this.getX() + offset[0], this.getY() + offset[1], this.getTextColor(this.isHovered), false);
        }
    }

    @Override
    public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
        this.tooltip.accept(tooltip, this.getState());
    }
}

