/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiReactiveList
extends Button {
    static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("hud_elements");
    protected Supplier<List<String>> entries;
    private final int[] padding = new int[]{0, 0, 0, 0};
    private boolean needsSlider = false;
    protected int perPage;
    private final float textScale = 1.0f;
    protected int offset;
    private int maxOffset;
    private int targetEntry = -1;
    private int hoverTimer = 0;
    public int selectedOption = -1;

    public GuiReactiveList(int x, int y, int w, int h, GuiButtonIE.IIEPressable<? extends GuiReactiveList> handler, Supplier<List<String>> entries) {
        super(x, y, w, h, (Component)Component.empty(), handler, DEFAULT_NARRATION);
        this.entries = entries;
    }

    private void recalculateEntries() {
        int length = this.entries.get().size();
        float f = this.height - this.padding[0] - this.padding[1];
        Objects.requireNonNull(ClientUtils.mc().font);
        this.perPage = (int)(f / (9.0f * 1.0f));
        if (this.perPage < length) {
            this.needsSlider = true;
            this.maxOffset = length - this.perPage;
            this.offset = Math.min(this.offset, this.maxOffset);
        } else {
            this.needsSlider = false;
            this.offset = 0;
            this.maxOffset = 0;
        }
    }

    public GuiReactiveList setPadding(int up, int down, int left, int right) {
        this.padding[0] = up;
        this.padding[1] = down;
        this.padding[2] = left;
        this.padding[3] = right;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    /*
     * Unable to fully structure code
     */
    public void renderWidget(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.recalculateEntries();
        entries = this.entries.get();
        fr = ClientUtils.mc().font;
        mmY = my - this.getY();
        strWidth = this.width - this.padding[2] - this.padding[3] - (this.needsSlider != false ? 6 : 0);
        if (this.needsSlider) {
            graphics.blit(GuiReactiveList.TEXTURE, this.getX() + this.width - 6, this.getY(), 16, 136, 6, 4);
            graphics.blit(GuiReactiveList.TEXTURE, this.getX() + this.width - 6, this.getY() + this.height - 4, 16, 144, 6, 4);
            for (i = 0; i < this.height - 8; i += 2) {
                graphics.blit(GuiReactiveList.TEXTURE, this.getX() + this.width - 6, this.getY() + 4 + i, 16, 141, 6, 2);
            }
            Objects.requireNonNull(fr);
            sliderSize = Math.max(6, this.height - this.maxOffset * 9);
            silderShift = (float)(this.height - sliderSize) / (float)this.maxOffset * (float)this.offset;
            graphics.blit(GuiReactiveList.TEXTURE, this.getX() + this.width - 5, (int)((float)this.getY() + silderShift + 1.0f), 20, 129, 4, 2);
            graphics.blit(GuiReactiveList.TEXTURE, this.getX() + this.width - 5, (int)((float)this.getY() + silderShift + (float)sliderSize - 4.0f), 20, 132, 4, 3);
            for (i = 0; i < sliderSize - 7; ++i) {
                graphics.blit(GuiReactiveList.TEXTURE, this.getX() + this.width - 5, (int)((float)this.getY() + silderShift + 3.0f + (float)i), 20, 131, 4, 1);
            }
        }
        graphics.pose().scale(1.0f, 1.0f, 1.0f);
        this.isHovered = this.active != false && mx >= this.getX() && mx < this.getX() + this.width && my >= this.getY() && my < this.getY() + this.height;
        hasTarget = false;
        for (i = 0; i < Math.min(this.perPage, entries.size()); ++i) {
            j = this.offset + i;
            col = 0xE0E0E0;
            if (!this.isHovered) ** GOTO lbl-1000
            Objects.requireNonNull(fr);
            if (mmY < i * 9) ** GOTO lbl-1000
            Objects.requireNonNull(fr);
            if (mmY < (i + 1) * 9) {
                v0 = true;
            } else lbl-1000:
            // 3 sources

            {
                v0 = selectionHover = false;
            }
            if (selectionHover) {
                hasTarget = true;
                if (this.targetEntry != j) {
                    this.targetEntry = j;
                    this.hoverTimer = 0;
                } else {
                    ++this.hoverTimer;
                }
                col = -557004;
            }
            if (j > entries.size() - 1) {
                j = entries.size() - 1;
            }
            if ((overLength = (s = entries.get(j)).length() - fr.plainSubstrByWidth((String)s, strWidth).length()) > 0) {
                if (selectionHover && this.hoverTimer > 20) {
                    textOffset = this.hoverTimer / 10 % s.length();
                    s = s.substring(textOffset) + " " + s.substring(0, textOffset);
                }
                s = fr.plainSubstrByWidth((String)s, strWidth);
            }
            tx = (float)(this.getX() + this.padding[2]) / 1.0f;
            v1 = this.getY() + this.padding[0];
            Objects.requireNonNull(fr);
            ty = (float)(v1 + 9 * i) / 1.0f;
            graphics.pose().translate(tx, ty, 0.0f);
            graphics.drawString(fr, (String)s, 0, 0, col);
            graphics.pose().translate(-tx, -ty, 0.0f);
        }
        graphics.pose().scale(1.0f, 1.0f, 1.0f);
        if (!hasTarget) {
            this.targetEntry = -1;
            this.hoverTimer = 0;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY != 0.0 && this.maxOffset > 0) {
            if (deltaY < 0.0 && this.offset < this.maxOffset) {
                ++this.offset;
            }
            if (deltaY > 0.0 && this.offset > 0) {
                --this.offset;
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mx, double my, int key) {
        this.selectedOption = -1;
        if (this.active && this.visible && this.isValidClickButton(key) && this.clicked(mx, my)) {
            Font fr = ClientUtils.mc().font;
            double mmY = my - (double)this.getY();
            for (int i = 0; i < Math.min(this.perPage, this.entries.get().size()); ++i) {
                Objects.requireNonNull(fr);
                if (!(mmY >= (double)(i * 9))) continue;
                Objects.requireNonNull(fr);
                if (!(mmY < (double)((i + 1) * 9))) continue;
                this.selectedOption = this.offset + i;
            }
        }
        super.mouseClicked(mx, my, key);
        return this.selectedOption != -1;
    }
}

