/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.MachineInterfaceScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class GuiSelectBox<E>
extends GuiButtonState<E> {
    private static final int WIDTH_LEFT = 8;
    private static final int WIDTH_MIDDLE = 4;
    private static final int WIDTH_RIGHT = 12;
    private static final int WIDTH_STATIC = 20;
    private static final int WIDTH_BUTTON = 10;
    private static final int HEIGHT_BASE = 16;
    private static final int OPEN_OFFSET = 8;
    private static final int TEXT_INDENT = 4;
    private final Supplier<E[]> optionGetter;
    private final Function<E, Component> messageGetter;
    private final int minWidth;
    private boolean opened = false;
    private int openedHeight;
    private int selectedState = -1;

    public GuiSelectBox(int x, int y, int minWidth, Supplier<E[]> optionGetter, IntSupplier selectedOption, Function<E, Component> messageGetter, GuiButtonIE.IIEPressable<GuiSelectBox<E>> handler) {
        super(x, y, 64, 16, (Component)Component.empty(), optionGetter.get(), selectedOption, MachineInterfaceScreen.TEXTURE, 166, 18, -1, btn -> handler.onIEPress((GuiSelectBox)btn));
        this.optionGetter = optionGetter;
        this.messageGetter = messageGetter;
        this.minWidth = minWidth;
        this.recalculateOptionsAndSize();
    }

    public void recalculateOptionsAndSize() {
        this.states = this.optionGetter.get();
        this.width = Math.max(20 + this.minWidth, 20 + Arrays.stream(this.states).mapToInt(value -> ClientUtils.mc().font.width((FormattedText)this.messageGetter.apply(value))).max().orElse(this.width));
        Objects.requireNonNull(ClientUtils.mc().font);
        this.openedHeight = 9 * this.states.length;
    }

    public int getClickedState() {
        return this.selectedState != -1 ? this.selectedState : this.getStateAsInt();
    }

    public Component getMessage() {
        return this.messageGetter.apply(this.getState());
    }

    @Override
    protected int getTextColor(boolean highlighted) {
        if (highlighted) {
            return -557004;
        }
        return 0x555555;
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.opened) {
            this.opened = true;
            this.height = 16 + this.openedHeight;
        } else {
            int sel = this.getHighlightedIndex(mouseX, mouseY);
            if (sel != -1) {
                this.selectedState = sel;
                this.onPress.onPress((Button)this);
            }
            this.opened = false;
            this.height = 16;
        }
    }

    private int getHighlightedIndex(double mouseX, double mouseY) {
        if (mouseX > (double)(this.getX() + (this.width - 10))) {
            return -1;
        }
        double d = mouseY - (double)this.getY() - 8.0;
        Objects.requireNonNull(ClientUtils.mc().font);
        int calc = (int)(d / 9.0);
        return calc >= 0 && calc < this.states.length ? calc : -1;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (this.visible) {
            Font fontrenderer = mc.font;
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.blendFunc((int)770, (int)771);
            graphics.blit(this.texture, this.getX(), this.getY(), this.texU, this.texV, 8, 16);
            for (int i = 0; i < this.width - 20; i += 4) {
                graphics.blit(this.texture, this.getX() + 8 + i, this.getY(), this.texU + 8 + 1, this.texV, 4, 16);
            }
            graphics.blit(this.texture, this.getX() + this.width - 12, this.getY(), this.texU + 8 + 4 + 2, this.texV, 12, 16);
            if (!this.opened) {
                Component text = this.getMessage();
                int textX = this.getX() + 4;
                int n = this.getY() + 8;
                Objects.requireNonNull(fontrenderer);
                int textY = n - 9 / 2;
                graphics.drawString(fontrenderer, text, textX, textY, this.getTextColor(this.isHovered), false);
            } else {
                int j;
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 2.0f);
                int openV = this.texV + 17;
                int borderV = this.texV + 20;
                for (j = 0; j < this.openedHeight; j += 2) {
                    graphics.blit(this.texture, this.getX(), this.getY() + 8 + j, this.texU, openV, 8, 2);
                    for (int i = 0; i < this.width - 20; i += 4) {
                        graphics.blit(this.texture, this.getX() + 8 + i, this.getY() + 8 + j, this.texU + 8 + 1, openV, 4, 2);
                    }
                    graphics.blit(this.texture, this.getX() + this.width - 12, this.getY() + 8 + j, this.texU + 8 + 4 + 2, openV, 12, 2);
                }
                graphics.blit(this.texture, this.getX(), this.getY() + 8 + this.openedHeight, this.texU, borderV, 8, 2);
                for (int i = 0; i < this.width - 20; i += 4) {
                    graphics.blit(this.texture, this.getX() + 8 + i, this.getY() + 8 + this.openedHeight, this.texU + 8 + 1, borderV, 4, 2);
                }
                graphics.blit(this.texture, this.getX() + this.width - 12, this.getY() + 8 + this.openedHeight, this.texU + 8 + 4 + 2, borderV, 12, 2);
                for (j = 0; j < this.states.length; ++j) {
                    Component text = this.messageGetter.apply(this.states[j]);
                    int textX = this.getX() + 4;
                    int n = this.getY() + 8;
                    Objects.requireNonNull(fontrenderer);
                    int textY = n + j * 9;
                    boolean highlighted = this.isHovered && this.getHighlightedIndex(mouseX, mouseY) == j;
                    graphics.drawString(fontrenderer, text, textX, textY, this.getTextColor(highlighted), false);
                }
                graphics.pose().popPose();
            }
        }
    }
}

