/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;

public class WidgetRowList<R extends WidgetRow> {
    private int xPos;
    private final int yPos;
    private final int rowHeight;
    private final int rowWidth;
    private final int maxScroll;
    private final WidgetAssemblyFunction<?>[] widgetFunctions;
    private final LinkedList<WidgetRow> rows = new LinkedList();
    private int scrollIndex = 0;

    public WidgetRowList(int xPos, int yPos, int rowHeight, int maxScroll, WidgetAssemblyFunction<?> ... widgets) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.rowHeight = rowHeight;
        this.maxScroll = maxScroll;
        this.widgetFunctions = widgets;
        AbstractWidget[] dummyRow = this.assembleWidgets(() -> 0);
        int maxX = dummyRow[dummyRow.length - 1].getX() + dummyRow[dummyRow.length - 1].getWidth();
        this.rowWidth = maxX - xPos;
    }

    private AbstractWidget[] assembleWidgets(IntSupplier rowIndex) {
        return this.assembleWidgets(this.xPos, this.yPos + rowIndex.getAsInt() * this.getRowHeight(), rowIndex);
    }

    private AbstractWidget[] assembleWidgets(int x, int y, IntSupplier rowIndex) {
        AbstractWidget[] widgets = new AbstractWidget[this.widgetFunctions.length];
        for (int iW = 0; iW < this.widgetFunctions.length; ++iW) {
            widgets[iW] = this.widgetFunctions[iW].apply(x, y, rowIndex);
            x = widgets[iW].getX() + widgets[iW].getWidth();
        }
        return widgets;
    }

    public WidgetRow addRow(@Nullable Consumer<AbstractWidget> screenAddFunction) {
        int y = this.yPos;
        if (!this.rows.isEmpty()) {
            y = this.rows.getLast().widgets[0].getY() + this.getRowHeight();
        }
        WidgetRow row = new WidgetRow(this, this.rows.size(), this.xPos, y);
        if (screenAddFunction != null) {
            for (AbstractWidget widget : row.widgets) {
                screenAddFunction.accept(widget);
            }
        }
        if (row.rowIndex - this.scrollIndex >= this.maxScroll) {
            row.hide();
        }
        this.rows.add(row);
        return row;
    }

    public AbstractWidget[] removeRow(int rowIndex) {
        AbstractWidget[] ret = this.rows.remove((int)rowIndex).widgets;
        this.rows.forEach(row -> row.shiftIndex(rowIndex));
        int nextOffscreen = this.scrollIndex + this.maxScroll - 1;
        if (nextOffscreen < this.rows.size()) {
            this.rows.get(nextOffscreen).show();
        }
        return ret;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowWidth() {
        return this.rowWidth;
    }

    public void setXPos(int newX) {
        this.xPos = newX;
    }

    public void scrollDown() {
        if (this.scrollIndex + 1 < this.rows.size()) {
            this.rows.get(this.scrollIndex).hide();
            this.rows.forEach(WidgetRow::shiftUp);
            if (this.rows.size() > this.maxScroll + this.scrollIndex) {
                this.rows.get(this.maxScroll + this.scrollIndex).show();
            }
            ++this.scrollIndex;
        }
    }

    public void scrollUp() {
        if (this.scrollIndex > 0) {
            this.rows.get(--this.scrollIndex).show();
            this.rows.forEach(WidgetRow::shiftDown);
            if (this.rows.size() > this.maxScroll + this.scrollIndex) {
                this.rows.get(this.maxScroll + this.scrollIndex).hide();
            }
        }
    }

    public void scrollTo(int rowIndex) {
        int scrollsNeeded = rowIndex - this.scrollIndex - this.maxScroll;
        for (int i = 0; i <= scrollsNeeded; ++i) {
            this.scrollDown();
        }
    }

    public static interface WidgetAssemblyFunction<W extends AbstractWidget> {
        public W apply(int var1, int var2, IntSupplier var3);
    }

    public static class WidgetRow {
        private final WidgetRowList<?> list;
        private int rowIndex;
        private final AbstractWidget[] widgets;

        public WidgetRow(WidgetRowList<?> list, int initialIdx, int x, int y) {
            this.list = list;
            this.rowIndex = initialIdx;
            this.widgets = list.assembleWidgets(x, y, () -> this.rowIndex);
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        private void shiftIndex(int removed) {
            if (this.rowIndex > removed) {
                --this.rowIndex;
                this.shiftUp();
            }
        }

        public void shiftDown() {
            for (AbstractWidget button : this.widgets) {
                button.setY(button.getY() + this.list.getRowHeight());
            }
        }

        public void shiftUp() {
            for (AbstractWidget button : this.widgets) {
                button.setY(button.getY() - this.list.getRowHeight());
            }
        }

        public void hide() {
            for (AbstractWidget button : this.widgets) {
                button.visible = false;
            }
        }

        public void show() {
            for (AbstractWidget button : this.widgets) {
                button.visible = true;
            }
        }
    }
}

