/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.info;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.gui.IESlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BlueprintOutputArea
extends InfoArea {
    private final IESlot.BlueprintOutput slot;

    public BlueprintOutputArea(IESlot.BlueprintOutput slot, int guiLeft, int guiTop) {
        super(new Rect2i(guiLeft + slot.x, guiTop + slot.y, 16, 16));
        this.slot = slot;
    }

    @Override
    protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        if (!this.slot.isOnPage()) {
            return;
        }
        BlueprintCraftingRecipe recipe = this.slot.recipe;
        if (recipe.output.get().isEmpty() || this.slot.hasItem()) {
            return;
        }
        tooltip.add((Component)TextUtils.applyFormat((Component)recipe.output.get().getHoverName().copy(), recipe.output.get().getRarity().color));
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (IngredientWithSize stack : recipe.inputs) {
            ItemStack toAdd = ItemHandlerHelper.copyStackWithSize((ItemStack)stack.getRandomizedExampleStack(ClientUtils.mc().player.tickCount), (int)stack.getCount());
            if (toAdd.isEmpty()) continue;
            boolean isNew = true;
            for (ItemStack ss : inputs) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)ss, (ItemStack)toAdd)) continue;
                ss.grow(toAdd.getCount());
                isNew = false;
                break;
            }
            if (!isNew) continue;
            inputs.add(toAdd.copy());
        }
        for (ItemStack ss : inputs) {
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.literal((String)(ss.getCount() + "x ")).append(ss.getHoverName()), ChatFormatting.GRAY));
        }
    }

    @Override
    public void draw(GuiGraphics graphics) {
        if (!this.slot.isOnPage()) {
            return;
        }
        ItemStack ghostStack = this.slot.recipe.output.get();
        if (ghostStack.isEmpty() || this.slot.hasItem()) {
            return;
        }
        graphics.renderItem(ghostStack, this.area.getX(), this.area.getY());
        graphics.fill(RenderType.guiGhostRecipeOverlay(), this.area.getX(), this.area.getY(), this.area.getX() + this.area.getWidth(), this.area.getY() + this.area.getHeight(), -1154272461);
    }
}

