/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.info;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class FluidInfoArea
extends InfoArea {
    private final IFluidTank tank;
    private final Rect2i area;
    private final int overlayUMin;
    private final int overlayVMin;
    private final int overlayWidth;
    private final int overlayHeight;
    private final ResourceLocation overlayTexture;

    public FluidInfoArea(IFluidTank tank, Rect2i area, int overlayUMin, int overlayVMin, int overlayWidth, int overlayHeight, ResourceLocation overlayTexture) {
        super(area);
        this.tank = tank;
        this.area = area;
        this.overlayUMin = overlayUMin;
        this.overlayVMin = overlayVMin;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
        this.overlayTexture = overlayTexture;
    }

    @Override
    public void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        FluidInfoArea.fillTooltip(this.tank.getFluid(), this.tank.getCapacity(), tooltip::add);
    }

    public static void fillTooltip(FluidStack fluid, int tankCapacity, Consumer<Component> tooltip) {
        if (!fluid.isEmpty()) {
            tooltip.accept((Component)TextUtils.applyFormat(fluid.getDisplayName(), fluid.getFluid().getFluidType().getRarity((FluidStack)fluid).color));
        } else {
            tooltip.accept((Component)Component.translatable((String)"gui.immersiveengineering.empty"));
        }
        Fluid fluid2 = fluid.getFluid();
        if (fluid2 instanceof PotionFluid) {
            PotionFluid potion = (PotionFluid)fluid2;
            potion.addInformation(fluid, tooltip);
        }
        if (ClientUtils.mc().options.advancedItemTooltips && !fluid.isEmpty()) {
            if (!Screen.hasShiftDown()) {
                tooltip.accept((Component)Component.translatable((String)"desc.immersiveengineering.info.holdShiftForInfo"));
            } else {
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)("Fluid Registry: " + BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid()))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)("Density: " + fluid.getFluid().getFluidType().getDensity(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)("Temperature: " + fluid.getFluid().getFluidType().getTemperature(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)("Viscosity: " + fluid.getFluid().getFluidType().getViscosity(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)("NBT Data: " + fluid.getTag())), ChatFormatting.DARK_GRAY));
            }
        }
        if (tankCapacity > 0) {
            tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)(fluid.getAmount() + "/" + tankCapacity + "mB")), ChatFormatting.GRAY));
        } else if (tankCapacity == 0) {
            tooltip.accept((Component)TextUtils.applyFormat((Component)Component.literal((String)(fluid.getAmount() + "mB")), ChatFormatting.GRAY));
        }
    }

    @Override
    public void draw(GuiGraphics graphics) {
        FluidStack fluid = this.tank.getFluid();
        float capacity = this.tank.getCapacity();
        graphics.pose().pushPose();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        if (!fluid.isEmpty()) {
            int fluidHeight = (int)((float)this.area.getHeight() * ((float)fluid.getAmount() / capacity));
            GuiHelper.drawRepeatedFluidSpriteGui((MultiBufferSource)buffer, graphics.pose(), fluid, this.area.getX(), this.area.getY() + this.area.getHeight() - fluidHeight, this.area.getWidth(), fluidHeight);
        }
        int xOff = (this.area.getWidth() - this.overlayWidth) / 2;
        int yOff = (this.area.getHeight() - this.overlayHeight) / 2;
        RenderType renderType = IERenderTypes.getGui(this.overlayTexture);
        GuiHelper.drawTexturedRect(buffer.getBuffer(renderType), graphics.pose(), this.area.getX() + xOff, this.area.getY() + yOff, this.overlayWidth, this.overlayHeight, 256.0f, this.overlayUMin, this.overlayUMin + this.overlayWidth, this.overlayVMin, this.overlayVMin + this.overlayHeight);
        buffer.endBatch();
        graphics.pose().popPose();
    }
}

