/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.util.fakeworld.TemplateWorld;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ManualElementMultiblock
extends SpecialManualElements {
    private final MultiblockHandler.IMultiblock multiblock;
    private final ClientMultiblocks.MultiblockManualData renderProperties;
    private boolean canTick = true;
    private boolean showCompleted = false;
    private float scale = 50.0f;
    private float transX = 0.0f;
    private float transY = 0.0f;
    private Transformation additionalTransform;
    private List<Component> componentTooltip;
    private final MultiblockRenderInfo renderInfo;
    private final TemplateWorld structureWorld;
    private final int yOffTotal;
    private final ClientLevel level;
    private long lastStep = -1L;
    private long lastPrintedErrorTimeMs = -1L;
    private static final Component greenTick = TextUtils.applyFormat((Component)Component.literal((String)"\u2713"), ChatFormatting.GREEN, ChatFormatting.BOLD).append(" ");

    public ManualElementMultiblock(ManualInstance manual, MultiblockHandler.IMultiblock multiblock) {
        super(manual);
        this.level = Objects.requireNonNull(Minecraft.getInstance().level);
        this.multiblock = multiblock;
        this.renderProperties = ClientMultiblocks.get(multiblock);
        List<StructureTemplate.StructureBlockInfo> structure = multiblock.getStructure((Level)this.level);
        this.renderInfo = new MultiblockRenderInfo(structure);
        float diagLength = (float)Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength);
        this.structureWorld = new TemplateWorld(structure, this.renderInfo, this.level.registryAccess());
        this.transX = 60.0f + (float)this.renderInfo.structureWidth / 2.0f;
        this.transY = 35.0f + diagLength / 2.0f;
        this.additionalTransform = new Transformation(null, new Quaternionf().rotateXYZ((float)Math.toRadians(25.0), 0.0f, 0.0f), null, new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-45.0), 0.0f));
        this.scale = multiblock.getManualScale();
        this.yOffTotal = (int)(this.transY + this.scale * diagLength / 2.0f);
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        int yOff = 0;
        if (this.multiblock.getStructure((Level)this.level) != null) {
            boolean canRenderFormed = this.renderProperties.canRenderFormedStructure();
            yOff = (int)((double)this.transY + (double)this.scale * Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0);
            pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, y + (int)this.transY - (canRenderFormed ? 11 : 5), 10, 10, 4, btn -> {
                GuiButtonManualNavigation btnNav = (GuiButtonManualNavigation)btn;
                this.canTick = !this.canTick;
                this.lastStep = -1L;
                btnNav.type = btnNav.type == 4 ? 5 : 4;
            }));
            if (this.renderInfo.structureHeight > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, y + (int)this.transY - (canRenderFormed ? 14 : 8) - 16, 10, 16, 3, btn -> this.renderInfo.setShowLayer(Math.min(this.renderInfo.showLayer + 1, this.renderInfo.structureHeight - 1))));
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, y + (int)this.transY + (canRenderFormed ? 14 : 8), 10, 16, 2, btn -> this.renderInfo.setShowLayer(Math.max(this.renderInfo.showLayer - 1, -1))));
            }
            if (canRenderFormed) {
                pageButtons.add(new GuiButtonManualNavigation(gui, x + 4, y + (int)this.transY + 1, 10, 10, 6, btn -> {
                    this.showCompleted = !this.showCompleted;
                }));
            }
        }
        this.checkMaterials();
        super.onOpened(gui, x, yOff, pageButtons);
    }

    private void checkMaterials() {
        NonNullList<ItemStack> totalMaterials = this.renderProperties.getTotalMaterials();
        if (totalMaterials != null) {
            ItemStack req;
            int ss;
            this.componentTooltip = new ArrayList<Component>();
            this.componentTooltip.add((Component)Component.translatable((String)"desc.immersiveengineering.info.reqMaterial"));
            int maxOff = 1;
            boolean hasAnyItems = false;
            boolean[] hasItems = new boolean[totalMaterials.size()];
            for (ss = 0; ss < totalMaterials.size(); ++ss) {
                ItemStack inSlot;
                req = (ItemStack)totalMaterials.get(ss);
                int reqSize = req.getCount();
                for (int slot = 0; slot < ManualUtils.mc().player.getInventory().getContainerSize() && ((inSlot = ManualUtils.mc().player.getInventory().getItem(slot)).isEmpty() || !ItemStack.isSameItem((ItemStack)inSlot, (ItemStack)req) || (reqSize -= inSlot.getCount()) > 0); ++slot) {
                }
                if (reqSize <= 0) {
                    hasItems[ss] = true;
                    if (!hasAnyItems) {
                        hasAnyItems = true;
                    }
                }
                maxOff = Math.max(maxOff, ("" + req.getCount()).length());
            }
            for (ss = 0; ss < totalMaterials.size(); ++ss) {
                req = (ItemStack)totalMaterials.get(ss);
                int indent = maxOff - ("" + req.getCount()).length();
                StringBuilder sIndent = new StringBuilder();
                if (indent > 0) {
                    sIndent.append("0".repeat(indent));
                }
                MutableComponent s = hasItems[ss] ? greenTick.copy() : Component.literal((String)(hasAnyItems ? "   " : ""));
                s.append((Component)TextUtils.applyFormat((Component)Component.literal((String)(sIndent.toString() + req.getCount() + "x ")), ChatFormatting.GRAY));
                if (!req.isEmpty()) {
                    s.append((Component)TextUtils.applyFormat((Component)req.getHoverName().copy(), req.getRarity().color));
                } else {
                    s.append("???");
                }
                this.componentTooltip.add((Component)s);
            }
        }
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        if (this.multiblock.getStructure((Level)this.level) != null) {
            MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
            PoseStack transform = graphics.pose();
            PoseStack.Pose lastEntryBeforeTry = transform.last();
            try {
                long currentTime = System.currentTimeMillis();
                if (this.lastStep < 0L) {
                    this.lastStep = currentTime;
                } else if (this.canTick && currentTime - this.lastStep > 500L) {
                    this.renderInfo.step();
                    this.lastStep = currentTime;
                }
                int structureLength = this.renderInfo.structureLength;
                int structureWidth = this.renderInfo.structureWidth;
                int structureHeight = this.renderInfo.structureHeight;
                transform.pushPose();
                BlockRenderDispatcher blockRender = Minecraft.getInstance().getBlockRenderer();
                transform.translate(this.transX, this.transY, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
                transform.scale(this.scale, -this.scale, 1.0f);
                transform.pushTransformation(this.additionalTransform);
                transform.mulPose(new Quaternionf().rotateXYZ(0.0f, 1.5707964f, 0.0f));
                transform.translate((float)structureLength / -2.0f, (float)structureHeight / -2.0f, (float)structureWidth / -2.0f);
                if (this.showCompleted && this.renderProperties.canRenderFormedStructure()) {
                    transform.pushPose();
                    this.renderProperties.renderFormedStructure(transform, (MultiBufferSource)buffer);
                    transform.popPose();
                } else {
                    TransformingVertexBuilder translucentFullbright = new TransformingVertexBuilder((MultiBufferSource)buffer, IERenderTypes.TRANSLUCENT_FULLBRIGHT);
                    for (int h = 0; h < structureHeight; ++h) {
                        for (int l = 0; l < structureLength; ++l) {
                            for (int w = 0; w < structureWidth; ++w) {
                                BlockPos pos = new BlockPos(l, h, w);
                                BlockState state = this.structureWorld.getBlockState(pos);
                                if (state.isAir()) continue;
                                transform.pushPose();
                                transform.translate((float)l, (float)h, (float)w);
                                int overlay = pos.equals((Object)this.multiblock.getTriggerOffset()) ? OverlayTexture.pack((float)0.0f, (boolean)true) : OverlayTexture.NO_OVERLAY;
                                translucentFullbright.setOverlay(overlay);
                                ModelData modelData = ModelData.EMPTY;
                                BlockEntity te = this.structureWorld.getBlockEntity(pos);
                                if (te != null) {
                                    modelData = te.getModelData();
                                }
                                BakedModel model = blockRender.getBlockModel(state);
                                modelData = model.getModelData((BlockAndTintGetter)this.structureWorld, pos, state, modelData);
                                blockRender.getModelRenderer().tesselateBlock((BlockAndTintGetter)this.structureWorld, model, state, pos, transform, (VertexConsumer)translucentFullbright, false, this.structureWorld.random, state.getSeed(pos), overlay, modelData, null);
                                transform.popPose();
                            }
                        }
                    }
                }
                transform.popPose();
                transform.popPose();
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (now > this.lastPrintedErrorTimeMs + 1000L) {
                    e.printStackTrace();
                    this.lastPrintedErrorTimeMs = now;
                }
                while (lastEntryBeforeTry != transform.last()) {
                    transform.popPose();
                }
            }
            buffer.endBatch();
            if (this.componentTooltip != null) {
                graphics.drawString(this.manual.fontRenderer(), "?", 116, this.yOffTotal / 2 - 4, this.manual.getTextColour());
                if (mouseX >= 116 && mouseX < 122 && mouseY >= this.yOffTotal / 2 - 4 && mouseY < this.yOffTotal / 2 + 4) {
                    graphics.renderTooltip(this.manual.fontRenderer(), Language.getInstance().getVisualOrder(Collections.unmodifiableList(this.componentTooltip)), mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void mouseDragged(int x, int y, double clickX, double clickY, double mouseX, double mouseY, double lastX, double lastY, int mouseButton) {
        if (clickX >= 40.0 && clickX < 144.0 && mouseX >= 20.0 && mouseX < 164.0 && clickY >= 30.0 && clickY < 130.0 && mouseY >= 30.0 && mouseY < 180.0) {
            double dx = mouseX - lastX;
            double dy = mouseY - lastY;
            this.additionalTransform = this.forRotation(dx * 80.0 / 104.0, dy * 0.8).compose(this.additionalTransform);
        }
    }

    private Transformation forRotation(double rX, double rY) {
        Vector3f axis = new Vector3f((float)rY, (float)rX, 0.0f);
        if ((double)axis.lengthSquared() < 0.001) {
            return Transformation.identity();
        }
        float angle = (float)Math.sqrt(axis.dot((Vector3fc)axis));
        axis.normalize();
        return new Transformation(null, new Quaternionf().rotateAxis((float)Math.toRadians(angle), (Vector3fc)axis), null, null);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return this.yOffTotal;
    }

    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    static class MultiblockRenderInfo
    implements Predicate<BlockPos> {
        public Map<BlockPos, StructureTemplate.StructureBlockInfo> data = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        private final int structureHeight;
        private final int structureLength;
        private final int structureWidth;
        private final int maxBlockIndex;
        private int showLayer = -1;
        private int blockIndex;

        MultiblockRenderInfo(List<StructureTemplate.StructureBlockInfo> structure) {
            int structureHeight = 0;
            int structureWidth = 0;
            int structureLength = 0;
            for (StructureTemplate.StructureBlockInfo block : structure) {
                structureHeight = Math.max(structureHeight, block.pos().getY() + 1);
                structureWidth = Math.max(structureWidth, block.pos().getZ() + 1);
                structureLength = Math.max(structureLength, block.pos().getX() + 1);
                this.data.put(block.pos(), block);
            }
            this.maxBlockIndex = this.blockIndex = structureHeight * structureLength * structureWidth;
            this.structureHeight = structureHeight;
            this.structureLength = structureLength;
            this.structureWidth = structureWidth;
        }

        void setShowLayer(int layer) {
            this.showLayer = layer;
            if (layer < 0) {
                this.reset();
            } else {
                this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
            }
        }

        public void reset() {
            this.blockIndex = this.maxBlockIndex;
        }

        void step() {
            int start = this.blockIndex;
            do {
                if (++this.blockIndex < this.maxBlockIndex) continue;
                this.blockIndex = 0;
            } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
        }

        private boolean isEmpty(int index) {
            int r = index % (this.structureLength * this.structureWidth);
            int x = r / this.structureWidth;
            int y = index / (this.structureLength * this.structureWidth);
            int z = r % this.structureWidth;
            return !this.data.containsKey(new BlockPos(x, y, z));
        }

        int getLimiter() {
            return this.blockIndex;
        }

        @Override
        public boolean test(BlockPos blockPos) {
            int index = blockPos.getZ() + this.structureWidth * (blockPos.getX() + this.structureLength * blockPos.getY());
            return index <= this.getLimiter();
        }
    }
}

