/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.client.models.ModelIEArmorBase;
import blusunrize.immersiveengineering.client.models.obj.callback.item.PowerpackCallbacks;
import blusunrize.immersiveengineering.client.render.ConnectionRenderer;
import blusunrize.immersiveengineering.client.render.tile.ShaderBannerRenderer;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class ModelPowerpack {
    private static final Supplier<ArmorModel> MODEL = Suppliers.memoize(() -> {
        EntityModelSet models = Minecraft.getInstance().getEntityModels();
        ModelPart layer = models.bakeLayer(ModelLayers.PLAYER);
        return new ArmorModel(layer);
    });
    public static Map<UUID, Connection> PLAYER_ATTACHED_TO = new HashMap<UUID, Connection>();
    private static final Cache<BannerKey, List<BannerLayer>> bannerCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    public static final LoadingCache<CatenaryKey, Connection.CatenaryData> CATENARY_DATA_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        Vector4f vec4f = new Vector4f(key.right ? -0.0625f : 0.0265f, -0.625f, 0.0f, 1.0f);
        Matrix4f mat4f = new Matrix4f();
        mat4f.setTranslation(key.arm.x / 16.0f, -key.arm.y / 16.0f, key.arm.z / 16.0f);
        mat4f.rotate((Quaternionfc)new Quaternionf().rotationZ(-key.arm.zRot));
        mat4f.rotate((Quaternionfc)new Quaternionf().rotationY(key.arm.yRot));
        mat4f.rotate((Quaternionfc)new Quaternionf().rotationX(-key.arm.xRot));
        vec4f.mul((Matrix4fc)mat4f);
        vec4f.mul(key.arm.xScale, key.arm.yScale, key.arm.zScale, 1.0f);
        double zFrom = key.crouched ? 0.625 : 0.25;
        double slack = key.crouched ? 1.25 : 1.5;
        return Connection.makeCatenaryData(new Vec3(key.right ? -0.484375 : 0.484375, -0.75, zFrom), new Vec3((double)vec4f.x(), (double)vec4f.y(), (double)vec4f.z()), slack);
    }));

    public static void render(LivingEntity toRender, ItemStack powerpack, EntityModel<?> baseModel, PoseStack matrixStackIn, MultiBufferSource buffers, int packedLightIn, int packedOverlayIn, float limbSwing, float limbSwingAmount, float ageInTicks, float partialTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.pushPose();
        boolean isCrouching = false;
        ModelPart leftArm = null;
        ModelPart rightArm = null;
        if (baseModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)baseModel;
            isCrouching = humanoidModel.crouching;
            leftArm = humanoidModel.leftArm;
            rightArm = humanoidModel.rightArm;
        } else if (baseModel instanceof HierarchicalModel) {
            HierarchicalModel hierarchicalModel = (HierarchicalModel)baseModel;
            try {
                leftArm = hierarchicalModel.root().getChild("left_arm");
                rightArm = hierarchicalModel.root().getChild("right_arm");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (baseModel instanceof AgeableListModel) {
            AgeableListModel ageable = (AgeableListModel)baseModel;
            if (baseModel.young) {
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                matrixStackIn.translate(0.0f, 1.5f, 0.0f);
            }
        }
        if (powerpack != null) {
            float max = EnergyHelper.getMaxEnergyStored(powerpack);
            float hierarchicalModel = Math.max(0.0f, (float)EnergyHelper.getEnergyStored(powerpack) / max);
        }
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(new Quaternionf().rotateXYZ((float)Math.PI, 0.0f, 0.0f));
        if (isCrouching) {
            matrixStackIn.translate(0.0f, -0.2f, 0.0f);
            matrixStackIn.mulPose(new Quaternionf().rotateXYZ(0.5f, 0.0f, 0.0f));
        }
        matrixStackIn.translate(0.0, -0.37, -0.187);
        ItemStack banner = PowerpackItem.getBannerStatic(powerpack);
        if (!banner.isEmpty()) {
            matrixStackIn.pushPose();
            InteractionHand[] shaderTexture = ShaderBannerRenderer.getShaderResourceLocation(banner, new ResourceLocation("immersiveengineering", "banner"));
            if (shaderTexture != null) {
                PowerpackCallbacks.THIRD_PERSON_PASS = 3;
                bakedModel = renderer.getModel(powerpack, toRender.level(), toRender, 0);
                bakedModel = ClientHooks.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)bakedModel, (ItemDisplayContext)ItemDisplayContext.FIXED, (boolean)false);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                VertexConsumer consumer = buffers.getBuffer(RenderType.entitySolid((ResourceLocation)shaderTexture));
                Minecraft.getInstance().getItemRenderer().renderModelLists(bakedModel, powerpack, packedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, consumer);
            } else {
                PowerpackCallbacks.THIRD_PERSON_PASS = 2;
                bakedModel = renderer.getModel(powerpack, toRender.level(), toRender, 0);
                bakedModel = ClientHooks.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)bakedModel, (ItemDisplayContext)ItemDisplayContext.FIXED, (boolean)false);
                matrixStackIn.translate(-0.5, -0.5, -0.5);
                for (BannerLayer layer : ModelPowerpack.getBannerLayers(banner, bakedModel)) {
                    VertexConsumer consumer = layer.getConsumer.apply(buffers);
                    for (BakedQuad quad : layer.bakedQuads()) {
                        consumer.putBulkData(matrixStackIn.last(), quad, layer.red(), layer.green(), layer.blue(), 1.0f, packedLightIn, OverlayTexture.NO_OVERLAY, false);
                    }
                }
            }
            matrixStackIn.popPose();
            PowerpackCallbacks.THIRD_PERSON_PASS = 1;
        }
        Minecraft.getInstance().getItemRenderer().render(powerpack, ItemDisplayContext.FIXED, false, matrixStackIn, buffers, packedLightIn, OverlayTexture.NO_OVERLAY, renderer.getModel(powerpack, toRender.level(), toRender, 0));
        PowerpackCallbacks.THIRD_PERSON_PASS = 0;
        matrixStackIn.popPose();
        for (InteractionHand hand : InteractionHand.values()) {
            ModelPart arm;
            ItemStack stack = toRender.getItemInHand(hand);
            boolean right = hand == InteractionHand.MAIN_HAND == (toRender.getMainArm() == HumanoidArm.RIGHT);
            ModelPart modelPart = arm = right ? rightArm : leftArm;
            if (stack.isEmpty() || !EnergyHelper.isFluxRelated(stack) || arm == null) continue;
            int armHash = (int)(1024.0f * arm.xRot) * 31 + (int)(1024.0f * arm.yRot) * 31 + (int)(1024.0f * arm.zRot) * 31 + (int)(arm.x * 31.0f) + (int)(arm.y * 31.0f) + (int)(arm.z * 31.0f) + (int)(arm.xScale * 31.0f) + (int)(arm.yScale * 31.0f) + (int)(arm.zScale * 31.0f) + (right ? 527 : 0) + (isCrouching ? 341 : 0);
            matrixStackIn.pushPose();
            matrixStackIn.scale(1.0f, -1.0f, 1.0f);
            TransformingVertexBuilder builder = new TransformingVertexBuilder(buffers, RenderType.entitySolid((ResourceLocation)InventoryMenu.BLOCK_ATLAS), matrixStackIn);
            ConnectionRenderer.renderConnection(builder, (Connection.CatenaryData)CATENARY_DATA_CACHE.getUnchecked((Object)new CatenaryKey(arm, isCrouching, right, armHash)), -0.015625, 15573060, packedLightIn, packedOverlayIn);
            matrixStackIn.popPose();
        }
        CompoundTag upgrades = PowerpackItem.getUpgradesStatic(powerpack);
        if (upgrades.getBoolean("antenna")) {
            Vec3 antennaBase = new Vec3(-0.09375, -0.3125, 0.21875).yRot((float)Math.toRadians(-toRender.yBodyRotO));
            Vec3 antennaTip = antennaBase.add(0.0, -2.5, 0.0);
            double distFromWire = 0.0;
            if (PLAYER_ATTACHED_TO.containsKey(toRender.getUUID())) {
                Connection connection = PLAYER_ATTACHED_TO.get(toRender.getUUID());
                Connection.CatenaryData catenary = connection.getCatenaryData();
                Vec3 a = Vec3.atLowerCornerOf((Vec3i)connection.getEndA().position());
                Vec3 ap = antennaTip.add(toRender.position()).subtract(a);
                Vec3 connectionDir = catenary.delta().normalize();
                distFromWire = ap.cross(connectionDir).length();
                double orthLength = ap.dot(catenary.delta()) / catenary.delta().dot(catenary.delta());
                Vec3 catPoint = connection.getPoint(orthLength, connection.getEndA());
                antennaTip = toRender.position().add(0.0, 1.25, 0.0).subtract(a.add(catPoint)).scale(1.02);
            }
            matrixStackIn.pushPose();
            matrixStackIn.mulPose(new Quaternionf().rotationY(-toRender.yBodyRotO * ((float)Math.PI / 180)));
            matrixStackIn.scale(-1.0f, 1.0f, 1.0f);
            Connection.CatenaryData renderCat = Connection.makeCatenaryData(antennaBase, antennaTip, 1.0 + distFromWire * 0.005);
            ConnectionRenderer.renderConnection(new TransformingVertexBuilder(buffers, RenderType.entitySolid((ResourceLocation)InventoryMenu.BLOCK_ATLAS), matrixStackIn), renderCat, -0.03125, 10792880, packedLightIn, packedOverlayIn);
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }

    private static List<BannerLayer> getBannerLayers(ItemStack banner, BakedModel bakedModel) {
        ListTag patternList;
        BannerKey key;
        ArrayList<BannerLayer> cached;
        Block block;
        DyeColor baseCol = DyeColor.WHITE;
        if (banner.getItem() instanceof BlockItem && (block = ((BlockItem)banner.getItem()).getBlock()) instanceof AbstractBannerBlock) {
            AbstractBannerBlock bannerBlock = (AbstractBannerBlock)block;
            baseCol = bannerBlock.getColor();
        }
        if ((cached = (ArrayList<BannerLayer>)bannerCache.getIfPresent((Object)(key = new BannerKey(baseCol, (patternList = BannerBlockEntity.getItemPatterns((ItemStack)banner)) != null ? patternList.toString() : "")))) != null) {
            return cached;
        }
        List list = BannerBlockEntity.createPatterns((DyeColor)baseCol, (ListTag)patternList);
        List quads = bakedModel.getQuads(null, null, ApiUtils.RANDOM_SOURCE);
        cached = new ArrayList<BannerLayer>(quads.size() * list.size());
        for (int i = 0; i < 17 && i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            Holder bannerpattern = (Holder)pair.getFirst();
            Material material = Sheets.getShieldMaterial((ResourceKey)((ResourceKey)bannerpattern.unwrapKey().orElseThrow()));
            float[] colour = ((DyeColor)pair.getSecond()).getTextureDiffuseColors();
            cached.add(new BannerLayer(mbs -> material.buffer(mbs, RenderType::entityCutoutNoCullZOffset), colour[0], colour[1], colour[2], quads));
        }
        bannerCache.put((Object)key, cached);
        return cached;
    }

    private record BannerLayer(Function<MultiBufferSource, VertexConsumer> getConsumer, float red, float green, float blue, List<BakedQuad> bakedQuads) {
    }

    private record CatenaryKey(ModelPart arm, boolean crouched, boolean right, int hash) {
        @Override
        public int hashCode() {
            return this.hash;
        }
    }

    private record BannerKey(DyeColor base, String patternText) {
    }

    private static class ArmorModel
    extends ModelIEArmorBase {
        public ArmorModel(ModelPart part) {
            super(part, RenderType::entityTranslucent);
        }
    }
}

