/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class FeedthroughModel
extends BakedIEModel
implements ICacheKeyProvider<Pair<FeedthroughCacheKey, Direction>> {
    public static final LoadingCache<FeedthroughCacheKey, SpecificFeedthroughModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build(CacheLoader.from(key -> new SpecificFeedthroughModel((FeedthroughCacheKey)key, s -> key.defaultColorMultipliers)));
    private static final ModelProperty<FeedthroughBlockEntity.FeedthroughData> FEEDTHROUGH = new ModelProperty();
    private static final Material MISSING_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
    private static final ItemTransforms transform = new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(), new Vector3f(), new Vector3f()), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.6f, 0.6f, 0.6f)), new ItemTransform(new Vector3f(), new Vector3f(0.0f, 0.3f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransform(new Vector3f(0.0f, 180.0f, 45.0f), new Vector3f(0.0f, 0.0f, -0.1875f), new Vector3f(0.5f, 0.5f, 0.5f)));
    private static final FeedthroughItemOverride INSTANCE = new FeedthroughItemOverride();

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(Pair<FeedthroughCacheKey, Direction> key) {
        return ((SpecificFeedthroughModel)CACHE.getUnchecked((Object)((FeedthroughCacheKey)key.getFirst()))).getQuads(null, (Direction)key.getSecond(), ApiUtils.RANDOM_SOURCE);
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData.Builder fullData = tileData.derive();
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof FeedthroughBlockEntity) {
            FeedthroughBlockEntity feedthrough = (FeedthroughBlockEntity)te;
            int color = Minecraft.getInstance().getBlockColors().getColor(feedthrough.stateForMiddle, world, pos, 0);
            FeedthroughBlockEntity.FeedthroughData d = new FeedthroughBlockEntity.FeedthroughData(feedthrough.stateForMiddle, feedthrough.reference, (Direction)state.getValue((Property)IEProperties.FACING_ALL), feedthrough.offset, color);
            fullData.with(FEEDTHROUGH, (Object)d);
        }
        return fullData.build();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        FeedthroughBlockEntity.FeedthroughData feedthroughInfo = (FeedthroughBlockEntity.FeedthroughData)data.get(FEEDTHROUGH);
        if (feedthroughInfo == null) {
            return MISSING_TEXTURE.sprite();
        }
        BakedModel centerModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(feedthroughInfo.baseState());
        return centerModel.getParticleIcon(ModelData.EMPTY);
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return transform;
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public Pair<FeedthroughCacheKey, Direction> getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        BlockState baseState = Blocks.STONE.defaultBlockState();
        WireType wire = WireType.COPPER;
        Direction facing = Direction.NORTH;
        int offset = 1;
        int colorMultiplier = -1;
        if (extraData.has(FEEDTHROUGH)) {
            FeedthroughBlockEntity.FeedthroughData data = (FeedthroughBlockEntity.FeedthroughData)extraData.get(FEEDTHROUGH);
            assert (data != null);
            baseState = data.baseState();
            wire = data.wire();
            facing = data.facing();
            offset = data.offset();
            colorMultiplier = data.colorMultiplier();
        }
        return Pair.of((Object)new FeedthroughCacheKey(wire, baseState, offset, facing, layer, colorMultiplier), (Object)side);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        return ICacheKeyProvider.super.getQuads(state, side, rand, extraData, layer);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.all();
    }

    public static class FeedthroughCacheKey {
        final WireType type;
        final BlockState baseState;
        final int offset;
        final Direction facing;
        final RenderType layer;
        final int defaultColorMultipliers;
        final Int2IntMap specificColorMultipliers;

        public FeedthroughCacheKey(WireType type, BlockState baseState, int offset, Direction facing, RenderType layer) {
            this(type, baseState, offset, facing, layer, -1);
        }

        public FeedthroughCacheKey(WireType type, BlockState baseState, int offset, Direction facing, RenderType layer, int colorMultiplier) {
            this.type = type;
            this.baseState = baseState;
            this.offset = offset;
            this.facing = facing;
            this.layer = layer;
            this.defaultColorMultipliers = colorMultiplier;
            this.specificColorMultipliers = new Int2IntOpenHashMap();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedthroughCacheKey that = (FeedthroughCacheKey)o;
            return this.offset == that.offset && this.defaultColorMultipliers == that.defaultColorMultipliers && this.type.equals(that.type) && this.baseState.equals(that.baseState) && this.facing == that.facing && Objects.equals(this.layer, that.layer);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.baseState, this.offset, this.facing, this.layer, this.defaultColorMultipliers);
        }
    }

    private static class SpecificFeedthroughModel
    extends FeedthroughModel {
        private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private static final Vec3[] vertices = new Vec3[]{new Vec3(0.75, (double)0.001f, 0.75), new Vec3(0.75, (double)0.001f, 0.25), new Vec3(0.25, (double)0.001f, 0.25), new Vec3(0.25, (double)0.001f, 0.75)};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(7);

        public SpecificFeedthroughModel(ItemStack stack) {
            WireType w = WireType.getValue(ItemNBTHelper.getString(stack, "wire"));
            BlockState state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)ItemNBTHelper.getTagCompound(stack, "middle"));
            if (state.getBlock() == Blocks.AIR) {
                state = Blocks.BOOKSHELF.defaultBlockState();
            }
            this.init(new FeedthroughCacheKey(w, state, Integer.MAX_VALUE, Direction.NORTH, null), i -> ClientUtils.mc().getItemColors().getColor(stack, i));
        }

        public SpecificFeedthroughModel(FeedthroughCacheKey key, Int2IntFunction colorMultiplier) {
            this.init(key, colorMultiplier);
        }

        private void init(FeedthroughCacheKey k, Int2IntFunction colorMultiplierBasic) {
            BakedModel model = ClientUtils.mc().getBlockRenderer().getBlockModelShaper().getBlockModel(k.baseState);
            if (colorMultiplierBasic == null) {
                ItemColors colors = ClientUtils.mc().getItemColors();
                ItemStack stack = new ItemStack((ItemLike)k.baseState.getBlock(), 1);
                colorMultiplierBasic = i -> colors.getColor(stack, i);
            }
            Int2IntFunction colorMultiplierFinal = colorMultiplierBasic;
            Int2IntFunction colorMultiplier = i -> {
                int ret = colorMultiplierFinal.get(i);
                k.specificColorMultipliers.put(i, ret);
                return ret;
            };
            boolean renderBlockInLayer = k.layer == null || model.getRenderTypes(k.baseState, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY).contains(k.layer);
            for (int j = 0; j < 7; ++j) {
                Direction side = j < 6 ? DirectionUtils.VALUES[j] : null;
                Direction facing = k.facing;
                switch (k.offset) {
                    case 0: {
                        if (!renderBlockInLayer) break;
                        List modelQuads = model.getQuads(k.baseState, side, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, k.layer);
                        this.quads.add(QuadTransformer.color(colorMultiplier).process(modelQuads));
                        break;
                    }
                    case 1: {
                        facing = facing.getOpposite();
                    }
                    case -1: {
                        if (k.layer != RenderType.solid()) break;
                        this.quads.add(this.getConnQuads(facing, side, k.type, new Matrix4(), k.layer));
                        break;
                    }
                    case 0x7FFFFFFF: {
                        Matrix4 mat = new Matrix4();
                        mat.translate(0.0, 0.0, 1.0);
                        ArrayList<BakedQuad> all = new ArrayList<BakedQuad>(this.getConnQuads(facing, side, k.type, mat, k.layer));
                        mat = new Matrix4();
                        mat.translate(0.0, 0.0, -1.0);
                        all.addAll(this.getConnQuads(facing.getOpposite(), side, k.type, mat, k.layer));
                        if (renderBlockInLayer) {
                            IQuadTransformer tintTransformer = QuadTransformer.color(colorMultiplier);
                            all.addAll(tintTransformer.process(model.getQuads(k.baseState, side, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, k.layer)));
                        }
                        this.quads.add(all);
                    }
                }
                if (this.quads.size() > j) continue;
                this.quads.add((List<BakedQuad>)ImmutableList.of());
            }
        }

        private List<BakedQuad> getConnQuads(Direction facing, Direction side, WireType type, Matrix4 mat, RenderType layer) {
            WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(type);
            mat.translate(0.5, 0.5, 0.5);
            if (facing.getAxis() == Direction.Axis.Y) {
                if (facing == Direction.UP) {
                    mat.rotate(Math.PI, 1.0, 0.0, 0.0);
                }
            } else {
                Direction rotateAround = DirectionUtils.rotateAround(facing, Direction.Axis.Y);
                mat.rotate(1.5707963267948966, rotateAround.getStepX(), rotateAround.getStepY(), rotateAround.getStepZ());
            }
            mat.translate(-0.5, -0.5, -0.5);
            BakedModel model = ClientUtils.mc().getBlockRenderer().getBlockModelShaper().getBlockModel((BlockState)info.connector().setValue((Property)IEProperties.FACING_ALL, (Comparable)Direction.DOWN));
            ArrayList<BakedQuad> conn = new ArrayList<BakedQuad>(model.getQuads(null, side, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, layer));
            if (side == facing) {
                conn.add(ModelUtils.createBakedQuad(vertices, Direction.UP, SpecificFeedthroughModel.getTexture(info), info.uvs(), WHITE, false));
            }
            return QuadTransformers.applying((Transformation)new Transformation(mat.toMatrix4f())).process(conn);
        }

        private static TextureAtlasSprite getTexture(WireApi.FeedthroughModelInfo info) {
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(info.texture());
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
            return this.quads.get(side == null ? 6 : side.get3DDataValue());
        }
    }

    private static class FeedthroughItemOverride
    extends ItemOverrides {
        private static final Cache<ItemStack, FeedthroughModel> ITEM_MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();

        private FeedthroughItemOverride() {
        }

        @Nonnull
        public BakedModel resolve(@Nonnull BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int unused) {
            Item connItem = IEBlocks.Connectors.FEEDTHROUGH.get().asItem();
            if (stack.getItem() == connItem) {
                try {
                    return (BakedModel)ITEM_MODEL_CACHE.get((Object)stack, () -> new SpecificFeedthroughModel(stack));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return originalModel;
        }
    }
}

