/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.mirror;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.mirror.CachedMirroredModel;
import blusunrize.immersiveengineering.client.models.mirror.MirroredModelLoader;
import blusunrize.immersiveengineering.client.models.mirror.MirroredModelState;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public record MirroredGeometry(UnbakedModel inner) implements IUnbakedGeometry<MirroredGeometry>
{
    public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLoc) {
        BakedModel baseResult = this.inner.bake(bakery, spriteGetter, (ModelState)new MirroredModelState(modelState), modelLoc);
        if (baseResult instanceof SimpleBakedModel) {
            SimpleBakedModel simpleModel = (SimpleBakedModel)baseResult;
            List<BakedQuad> unculledQuads = MirroredModelLoader.getReversedQuads(simpleModel, null);
            EnumMap<Direction, List<BakedQuad>> culledQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
            for (Direction d : DirectionUtils.VALUES) {
                culledQuads.put(d, MirroredModelLoader.getReversedQuads(simpleModel, d));
            }
            return new SimpleBakedModel(unculledQuads, culledQuads, baseResult.useAmbientOcclusion(), baseResult.usesBlockLight(), baseResult.isGui3d(), baseResult.getParticleIcon(ModelData.EMPTY), baseResult.getTransforms(), baseResult.getOverrides(), ModelUtils.copyTypes(simpleModel));
        }
        if (baseResult instanceof ICacheKeyProvider) {
            ICacheKeyProvider cachedModel = (ICacheKeyProvider)baseResult;
            return new CachedMirroredModel(cachedModel);
        }
        throw new RuntimeException("Tried to mirror model " + this.inner + " which is neither simple nor cacheable");
    }
}

