/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.client.models.CompositeBakedModel;
import blusunrize.immersiveengineering.client.models.split.PolygonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import malte0811.modelsplitter.ClumpedModel;
import malte0811.modelsplitter.SplitModel;
import malte0811.modelsplitter.math.ModelSplitterVec3i;
import malte0811.modelsplitter.model.OBJModel;
import malte0811.modelsplitter.model.Polygon;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public abstract class AbstractSplitModel<T extends BakedModel>
extends CompositeBakedModel<T> {
    @Nonnull
    private final Vec3i size;

    public AbstractSplitModel(T base, Vec3i size) {
        super(base);
        this.size = size;
    }

    @Override
    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData baseData = super.getModelData(world, pos, state, tileData);
        BlockEntity te = world.getBlockEntity(pos);
        BlockPos offset = null;
        if (te instanceof IModelOffsetProvider) {
            IModelOffsetProvider offsetProvider = (IModelOffsetProvider)te;
            offset = offsetProvider.getModelOffset(state, this.size);
        } else {
            Block block = state.getBlock();
            if (block instanceof IModelOffsetProvider) {
                IModelOffsetProvider offsetProvider = (IModelOffsetProvider)block;
                offset = offsetProvider.getModelOffset(state, this.size);
            }
        }
        if (offset != null) {
            return baseData.derive().with(IEProperties.Model.SUBMODEL_OFFSET, (Object)offset).build();
        }
        return baseData;
    }

    protected Map<Vec3i, List<BakedQuad>> split(List<BakedQuad> in, Set<Vec3i> parts, ModelState transform) {
        List polys = in.stream().map(PolygonUtils::toPolygon).collect(Collectors.toList());
        SplitModel splitData = new SplitModel(new OBJModel(polys));
        Set<ModelSplitterVec3i> partsBMS = parts.stream().map(v -> new ModelSplitterVec3i(v.getX(), v.getY(), v.getZ())).collect(Collectors.toSet());
        ClumpedModel clumpedModel = new ClumpedModel(splitData, partsBMS);
        HashMap<Vec3i, List<BakedQuad>> map = new HashMap<Vec3i, List<BakedQuad>>();
        for (Map.Entry e : clumpedModel.getClumpedParts().entrySet()) {
            ArrayList<BakedQuad> subModelFaces = new ArrayList<BakedQuad>(e.getValue().getFaces().size());
            for (Polygon<PolygonUtils.ExtraQuadData> polygon : e.getValue().getFaces()) {
                subModelFaces.add(PolygonUtils.toBakedQuad(polygon, transform));
            }
            Vec3i mcKey = new Vec3i(e.getKey().x(), e.getKey().y(), e.getKey().z());
            map.put(mcKey, subModelFaces);
        }
        return map;
    }
}

