/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.client.utils.BakedQuadBuilder;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.UVCoords;
import malte0811.modelsplitter.model.Vertex;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PolygonUtils {
    private static int getOffset(VertexFormatElement element) {
        int offset = 0;
        for (VertexFormatElement e : DefaultVertexFormat.BLOCK.getElements()) {
            if (e == element) {
                return offset / 4;
            }
            offset += e.getByteSize();
        }
        throw new IllegalStateException("Did not find element with usage " + element.getUsage().name() + " and type " + element.getType().name());
    }

    public static Polygon<ExtraQuadData> toPolygon(BakedQuad quad) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(4);
        int posOffset = PolygonUtils.getOffset(DefaultVertexFormat.ELEMENT_POSITION);
        int uvOffset = PolygonUtils.getOffset(DefaultVertexFormat.ELEMENT_UV);
        int normalOffset = PolygonUtils.getOffset(DefaultVertexFormat.ELEMENT_NORMAL);
        int colorOffset = PolygonUtils.getOffset(DefaultVertexFormat.ELEMENT_COLOR);
        int color = quad.getVertices()[colorOffset];
        for (int v = 0; v < 4; ++v) {
            int baseOffset = v * DefaultVertexFormat.BLOCK.getVertexSize() / 4;
            int packedNormal = quad.getVertices()[normalOffset + baseOffset];
            Vec3d normalVec = new Vec3d((byte)packedNormal, (byte)(packedNormal >> 8), (byte)(packedNormal >> 16)).normalize();
            UVCoords uv = new UVCoords(Float.intBitsToFloat(quad.getVertices()[uvOffset + baseOffset]), Float.intBitsToFloat(quad.getVertices()[uvOffset + baseOffset + 1]));
            Vec3d pos = new Vec3d(Float.intBitsToFloat(quad.getVertices()[baseOffset + posOffset]), Float.intBitsToFloat(quad.getVertices()[baseOffset + posOffset + 1]), Float.intBitsToFloat(quad.getVertices()[baseOffset + posOffset + 2]));
            vertices.add(new Vertex(pos, normalVec, uv));
            Preconditions.checkState((quad.getVertices()[baseOffset + colorOffset] == color ? 1 : 0) != 0, (Object)"All vertices in a quad must have the same color, otherwise we need changes in BMS");
        }
        return new Polygon<ExtraQuadData>(vertices, new ExtraQuadData(quad.getSprite(), new Vector4f((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 24) / 255.0f)));
    }

    public static BakedQuad toBakedQuad(Polygon<ExtraQuadData> poly, ModelState transform) {
        return PolygonUtils.toBakedQuad(poly.getPoints(), poly.getTexture(), transform.getRotation().blockCenterToCorner(), true, true);
    }

    public static BakedQuad toBakedQuad(List<Vertex> points, ExtraQuadData data, Transformation rotation, boolean absoluteUV, boolean shade) {
        Preconditions.checkArgument((points.size() == 4 ? 1 : 0) != 0);
        BakedQuadBuilder quadBuilder = new BakedQuadBuilder();
        Vector3f normal = new Vector3f();
        for (Vertex v : points) {
            Vector4f pos = new Vector4f();
            pos.set(PolygonUtils.toArray(v.position(), 4));
            normal.set(PolygonUtils.toArray(v.normal(), 3));
            rotation.transformPosition(pos);
            rotation.transformNormal(normal);
            pos.mul(1.0f / pos.w);
            double epsilon = 1.0E-5;
            for (int i = 0; i < 2; ++i) {
                if ((double)Math.abs((float)i - pos.x()) < 1.0E-5) {
                    pos.setComponent(0, (float)i);
                }
                if ((double)Math.abs((float)i - pos.y()) < 1.0E-5) {
                    pos.setComponent(1, (float)i);
                }
                if (!((double)Math.abs((float)i - pos.z()) < 1.0E-5)) continue;
                pos.setComponent(2, (float)i);
            }
            quadBuilder.putVertexData(new Vec3((double)pos.x(), (double)pos.y(), (double)pos.z()), new Vec3(normal), absoluteUV ? v.uv().u() : (double)data.sprite().getU((float)v.uv().u()), absoluteUV ? v.uv().v() : (double)data.sprite().getV((float)(1.0 - v.uv().v())), new float[]{data.color.x(), data.color.y(), data.color.z(), data.color.w()}, 1.0f);
        }
        return quadBuilder.bake(-1, Direction.getNearest((float)normal.x(), (float)normal.y(), (float)normal.z()), data.sprite(), shade);
    }

    private static float[] toArray(Vec3d vec, int length) {
        int i;
        float[] ret = new float[length];
        for (i = 0; i < 3; ++i) {
            ret[i] = (float)vec.get(i);
        }
        for (i = 3; i < length; ++i) {
            ret[i] = 1.0f;
        }
        return ret;
    }

    public record ExtraQuadData(TextureAtlasSprite sprite, Vector4f color) {
    }
}

