/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import org.joml.Vector4f;

public class IEShaderLayerCompositeTexture
extends AbstractTexture {
    private final ResourceLocation canvasTexture;
    private final ShaderLayer[] layers;

    public IEShaderLayerCompositeTexture(ResourceLocation canvasTexture, ShaderLayer[] layers) {
        this.canvasTexture = canvasTexture;
        this.layers = layers;
    }

    public void load(@Nonnull ResourceManager resourceManager) {
        this.releaseId();
        Resource iresource = (Resource)resourceManager.getResource(this.canvasTexture).orElseThrow();
        try (InputStream imageStream = iresource.open();
             NativeImage originalImage = NativeImage.read((InputStream)imageStream);){
            int canvasWidth = originalImage.getWidth();
            int canvasHeight = originalImage.getHeight();
            NativeImage finalTexture = new NativeImage(canvasWidth, canvasHeight, true);
            for (int layer = 0; layer < 17 && layer < this.layers.length; ++layer) {
                Object texPath = this.layers[layer].getTexture().getPath();
                if (!((String)texPath).startsWith("textures/")) {
                    texPath = "textures/" + (String)texPath;
                }
                if (!((String)texPath).endsWith(".png")) {
                    texPath = (String)texPath + ".png";
                }
                String texture = this.layers[layer].getTexture().getNamespace() + ":" + (String)texPath;
                Vector4f colour = this.layers[layer].getColor();
                Resource iresource1 = (Resource)resourceManager.getResource(new ResourceLocation(texture)).orElseThrow();
                try (InputStream texStream = iresource1.open();
                     NativeImage texureImage = NativeImage.read((InputStream)texStream);){
                    float[] mod = new float[]{colour.z(), colour.y(), colour.x(), colour.w()};
                    if ((double)mod[3] < 0.2) {
                        mod[3] = mod[3] * 2.5f;
                    }
                    IntFunction<Integer> uInterpolate = uIn -> uIn;
                    IntFunction<Integer> vInterpolate = vIn -> vIn;
                    int bufImg2Size = Math.min(texureImage.getWidth(), texureImage.getHeight());
                    int uMin = 0;
                    int vMin = 0;
                    int uMax = canvasWidth;
                    int vMax = canvasHeight;
                    double[] texBounds = this.layers[layer].getTextureBounds();
                    if (texBounds != null) {
                        double uOffset = texBounds[0] * (double)canvasWidth;
                        double vOffset = texBounds[1] * (double)canvasHeight;
                        double uScale = (double)bufImg2Size / ((texBounds[2] - texBounds[0]) * (double)canvasWidth);
                        double vScale = (double)bufImg2Size / ((texBounds[3] - texBounds[1]) * (double)canvasHeight);
                        uInterpolate = uIn -> (int)Math.round(((double)uIn - uOffset) * uScale);
                        vInterpolate = vIn -> (int)Math.round(((double)vIn - vOffset) * vScale);
                        uMin = (int)uOffset;
                        vMin = (int)vOffset;
                        uMax = (int)(texBounds[2] * (double)canvasWidth);
                        vMax = (int)(texBounds[3] * (double)canvasHeight);
                    }
                    try {
                        for (int v = vMin; v < vMax; ++v) {
                            for (int u = uMin; u < uMax; ++u) {
                                int color;
                                int interU = uInterpolate.apply(u) % bufImg2Size;
                                int interV = vInterpolate.apply(v) % bufImg2Size;
                                int iRGB = texureImage.getPixelRGBA(interU, interV);
                                float[] rgb = new float[]{(float)(iRGB & 0xFF) / 255.0f, (float)(iRGB >> 8 & 0xFF) / 255.0f, (float)(iRGB >> 16 & 0xFF) / 255.0f, (float)(iRGB >> 24 & 0xFF) / 255.0f};
                                if ((iRGB & 0xFF000000) == 0) continue;
                                int iNoise = originalImage.getPixelRGBA(u, v);
                                float[] noise = new float[]{(float)(iNoise & 0xFF) / 255.0f, (float)(iNoise >> 8 & 0xFF) / 255.0f, (float)(iNoise >> 16 & 0xFF) / 255.0f, (float)(iNoise >> 24 & 0xFF) / 255.0f};
                                for (int m = 0; m < 4; ++m) {
                                    rgb[m] = rgb[m] * mod[m] * noise[m];
                                }
                                int[] irgb = new int[]{(int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), (int)(rgb[3] * 255.0f)};
                                int i2 = irgb[0] + (irgb[1] << 8) + (irgb[2] << 16) + (irgb[3] << 24);
                                int pre = finalTexture.getPixelRGBA(u, v) >> 24 & 0xFF;
                                this.blendPixel(finalTexture, u, v, i2);
                                int post = finalTexture.getPixelRGBA(u, v);
                                if (pre == 0) {
                                    color = irgb[3] << 24 | post & 0xFFFFFF;
                                    finalTexture.setPixelRGBA(u, v, color);
                                    continue;
                                }
                                if ((post >> 24 & 0xFF) >= pre) continue;
                                color = pre << 24 | post & 0xFFFFFF;
                                finalTexture.setPixelRGBA(u, v, color);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            TextureUtil.prepareImage((int)this.getId(), (int)0, (int)finalTexture.getWidth(), (int)finalTexture.getHeight());
            finalTexture.upload(0, 0, 0, 0, 0, finalTexture.getWidth(), finalTexture.getHeight(), false, false, false, false);
        }
        catch (IOException ioexception) {
            IELogger.error("Couldn't load layered image", ioexception);
        }
    }

    private void blendPixel(NativeImage image, int xIn, int yIn, int colIn) {
        int existing = image.getPixelRGBA(xIn, yIn);
        float alphaIn = (float)FastColor.ARGB32.alpha((int)colIn) / 255.0f;
        float blueIn = (float)FastColor.ARGB32.blue((int)colIn) / 255.0f;
        float greenIn = (float)FastColor.ARGB32.green((int)colIn) / 255.0f;
        float redIn = (float)FastColor.ARGB32.red((int)colIn) / 255.0f;
        float alphaOld = (float)FastColor.ARGB32.alpha((int)existing) / 255.0f;
        float blueOld = (float)FastColor.ARGB32.blue((int)existing) / 255.0f;
        float greenOld = (float)FastColor.ARGB32.green((int)existing) / 255.0f;
        float redOld = (float)FastColor.ARGB32.red((int)existing) / 255.0f;
        float oldMixFactor = 1.0f - alphaIn;
        float alphaOut = alphaIn * alphaIn + alphaOld * oldMixFactor;
        float blueOut = blueIn * alphaIn + blueOld * oldMixFactor;
        float greenOut = greenIn * alphaIn + greenOld * oldMixFactor;
        float redOut = redIn * alphaIn + redOld * oldMixFactor;
        if (alphaOut > 1.0f) {
            alphaOut = 1.0f;
        }
        if (blueOut > 1.0f) {
            blueOut = 1.0f;
        }
        if (greenOut > 1.0f) {
            greenOut = 1.0f;
        }
        if (redOut > 1.0f) {
            redOut = 1.0f;
        }
        int redOutInt = (int)(alphaOut * 255.0f);
        int blueOutInt = (int)(blueOut * 255.0f);
        int greenOutInt = (int)(greenOut * 255.0f);
        int alphaOutInt = (int)(redOut * 255.0f);
        image.setPixelRGBA(xIn, yIn, FastColor.ARGB32.color((int)redOutInt, (int)blueOutInt, (int)greenOutInt, (int)alphaOutInt));
    }
}

