/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RevolvershotRenderer
extends EntityRenderer<RevolvershotEntity> {
    public RevolvershotRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(@Nonnull RevolvershotEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        VertexConsumer builder = bufferIn.getBuffer(IERenderTypes.getPositionTex(this.getTextureLocation(entity)));
        matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.PI / 180 * (entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks - 90.0f)).rotateZ((float)Math.PI / 180 * (entity.xRotO + (entity.getXRot() - entity.xRotO) * partialTicks)));
        matrixStackIn.scale(0.25f, 0.25f, 0.25f);
        Matrix4f mat = matrixStackIn.last().pose();
        builder.vertex(mat, 0.0f, 0.0f, -0.25f).uv(0.15625f, 0.3125f).endVertex();
        builder.vertex(mat, 0.0f, 0.0f, 0.25f).uv(0.0f, 0.3125f).endVertex();
        builder.vertex(mat, 0.0f, 0.5f, 0.25f).uv(0.0f, 0.15625f).endVertex();
        builder.vertex(mat, 0.0f, 0.5f, -0.25f).uv(0.15625f, 0.15625f).endVertex();
        builder.vertex(mat, 0.375f, 0.125f, 0.0f).uv(0.25f, 0.15625f).endVertex();
        builder.vertex(mat, 0.0f, 0.125f, 0.0f).uv(0.0f, 0.15625f).endVertex();
        builder.vertex(mat, 0.0f, 0.375f, 0.0f).uv(0.0f, 0.0f).endVertex();
        builder.vertex(mat, 0.375f, 0.375f, 0.0f).uv(0.25f, 0.0f).endVertex();
        builder.vertex(mat, 0.375f, 0.25f, -0.25f).uv(0.25f, 0.15625f).endVertex();
        builder.vertex(mat, 0.0f, 0.25f, -0.25f).uv(0.0f, 0.15625f).endVertex();
        builder.vertex(mat, 0.0f, 0.25f, 0.25f).uv(0.0f, 0.0f).endVertex();
        builder.vertex(mat, 0.375f, 0.25f, 0.25f).uv(0.25f, 0.0f).endVertex();
        matrixStackIn.popPose();
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull RevolvershotEntity entity) {
        return new ResourceLocation("immersiveengineering:textures/models/bullet.png");
    }
}

