/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class SawbladeRenderer
extends EntityRenderer<SawbladeEntity> {
    public static final String NAME = "sawblade_entity";
    public static DynamicModel MODEL;
    public static final ResourceLocation SAWBLADE;
    private static final IEProperties.VisibilityList DYNAMIC_GROUPS;
    private final ItemRenderer itemRenderer;

    public SawbladeRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.itemRenderer = renderManager.getItemRenderer();
    }

    public void render(SawbladeEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.translucent());
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockPos blockPos = entity.blockPosition();
        BlockState state = entity.getCommandSenderWorld().getBlockState(blockPos);
        BakedModel model = MODEL.get();
        matrixStackIn.pushPose();
        matrixStackIn.scale(0.75f, 0.75f, 0.75f);
        double yaw = entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks - 90.0f;
        double pitch = entity.xRotO + (entity.getXRot() - entity.xRotO) * partialTicks;
        matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.toRadians(yaw)).rotateZ((float)Math.toRadians(pitch)));
        if (!entity.isInGround()) {
            float spin = ((float)entity.tickCount + partialTicks) % 10.0f / 10.0f * ((float)Math.PI * 2);
            matrixStackIn.mulPose(new Quaternionf().rotateY(spin));
        }
        RenderType renderType = Sheets.cutoutBlockSheet();
        List quads = model.getQuads(state, null, RandomSource.create(), ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), DYNAMIC_GROUPS), renderType);
        this.itemRenderer.renderQuadList(matrixStackIn, bufferIn.getBuffer(renderType), quads, entity.getAmmo(), packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(@Nonnull SawbladeEntity entity) {
        return SAWBLADE;
    }

    static {
        SAWBLADE = new ResourceLocation("immersiveengineering", "item/sawblade_blade");
        DYNAMIC_GROUPS = IEProperties.VisibilityList.show("blade");
    }
}

