/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.mixin.accessors.client.MinecartRendererAccess;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class ShaderMinecartRenderer<T extends AbstractMinecart>
extends MinecartRenderer<T> {
    public static Int2ObjectMap<ItemStack> shadedCarts = new Int2ObjectOpenHashMap();
    private final MinecartRenderer<T> baseRenderer;
    private final MinecartModel<?> baseModel;

    public ShaderMinecartRenderer(MinecartRenderer<T> base, EntityRendererProvider.Context manager) {
        super(manager, ModelLayers.MINECART);
        this.baseRenderer = base;
        this.baseModel = this.getModel();
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ItemStack shader;
        ShaderCase sCase = null;
        if (shadedCarts.containsKey(entity.getId()) && (shader = (ItemStack)shadedCarts.get(entity.getId())) != null && !shader.isEmpty() && shader.getItem() instanceof IShaderItem) {
            sCase = ((IShaderItem)shader.getItem()).getShaderCase(shader, new ResourceLocation("immersiveengineering", "minecart"));
        }
        this.baseRenderer.render(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (sCase != null) {
            matrixStackIn.pushPose();
            this.applyTransforms(matrixStackIn, entity, partialTicks, entityYaw);
            List boxList = this.baseModel.root().getAllParts().collect(Collectors.toList());
            ((ModelPart)boxList.get((int)5)).y = 4.1f;
            for (int part = 0; part < boxList.size() - 1; ++part) {
                if (boxList.get(part) == null) continue;
                float scale = 1.0f;
                ShaderLayer[] layers = sCase.getLayers();
                for (int pass = 0; pass < layers.length; ++pass) {
                    if (!sCase.shouldRenderGroupForPass("" + part, pass)) continue;
                    Vector4f col = sCase.getRenderColor("" + part, pass, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
                    matrixStackIn.pushPose();
                    matrixStackIn.scale(scale, scale, scale);
                    RenderType type = sCase.getLayers()[pass].getRenderType(RenderType.entityTranslucent((ResourceLocation)sCase.getTextureReplacement(Integer.toString(part), pass)));
                    ModelPart subModel = (ModelPart)boxList.get(part);
                    subModel.render(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.NO_OVERLAY, col.x(), col.y(), col.z(), col.w());
                    matrixStackIn.popPose();
                }
            }
            matrixStackIn.popPose();
        }
    }

    private MinecartModel<?> getModel() {
        EntityModel<?> model = ((MinecartRendererAccess)this.baseRenderer).getModel();
        if (model instanceof MinecartModel) {
            return (MinecartModel)model;
        }
        return (MinecartModel)this.model;
    }

    private void applyTransforms(PoseStack matrixStackIn, T entityIn, float partialTicks, float entityYaw) {
        long i = (long)entityIn.getId() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        matrixStackIn.translate(f, f1, f2);
        double d0 = Mth.lerp((double)partialTicks, (double)((AbstractMinecart)entityIn).xOld, (double)entityIn.getX());
        double d1 = Mth.lerp((double)partialTicks, (double)((AbstractMinecart)entityIn).yOld, (double)entityIn.getY());
        double d2 = Mth.lerp((double)partialTicks, (double)((AbstractMinecart)entityIn).zOld, (double)entityIn.getZ());
        Vec3 vec3d = entityIn.getPos(d0, d1, d2);
        float f3 = Mth.lerp((float)partialTicks, (float)((AbstractMinecart)entityIn).xRotO, (float)entityIn.getXRot());
        if (vec3d != null) {
            Vec3 vec3d1 = entityIn.getPosOffs(d0, d1, d2, (double)0.3f);
            Vec3 vec3d2 = entityIn.getPosOffs(d0, d1, d2, (double)-0.3f);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            matrixStackIn.translate(vec3d.x - d0, (vec3d1.y + vec3d2.y) / 2.0 - d1, vec3d.z - d2);
            Vec3 vec3d3 = vec3d2.add(-vec3d1.x, -vec3d1.y, -vec3d1.z);
            if (vec3d3.length() != 0.0) {
                vec3d3 = vec3d3.normalize();
                entityYaw = (float)(Math.atan2(vec3d3.z, vec3d3.x) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec3d3.y) * 73.0);
            }
        }
        matrixStackIn.translate(0.0, 0.375, 0.0);
        matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.PI - (float)Math.PI / 180 * entityYaw).rotateZ((float)(-Math.PI) / 180 * f3));
        float f5 = (float)entityIn.getHurtTime() - partialTicks;
        float f6 = entityIn.getDamage() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            matrixStackIn.mulPose(new Quaternionf().rotateZ((float)Math.PI / 180 * Mth.sin((float)f5) * f5 * f6 / 10.0f * (float)entityIn.getHurtDir()));
        }
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
    }

    public static void overrideMinecartModels() {
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher rendererManager = mc.getEntityRenderDispatcher();
        HashMap mutableRenderers = new HashMap(rendererManager.renderers);
        for (Map.Entry entry : rendererManager.renderers.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof MinecartRenderer)) continue;
            MinecartRenderer minecartRender = (MinecartRenderer)v;
            mutableRenderers.put((EntityType)entry.getKey(), new ShaderMinecartRenderer(minecartRender, new EntityRendererProvider.Context(rendererManager, mc.getItemRenderer(), mc.getBlockRenderer(), mc.getEntityRenderDispatcher().getItemInHandRenderer(), mc.getResourceManager(), mc.getEntityModels(), mc.font)));
        }
        rendererManager.renderers = ImmutableMap.copyOf(mutableRenderers);
    }
}

