/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace.ArcFurnaceLogic;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class ArcFurnaceRenderer
extends IEMultiblockRenderer<ArcFurnaceLogic.State> {
    private TextureAtlasSprite hotMetal_flow = null;
    private TextureAtlasSprite hotMetal_still = null;
    public static final String NAME = "arc_furnace_electrodes";
    public static DynamicModel ELECTRODES;
    public static final ResourceLocation HOT_METLA_STILL;
    public static final ResourceLocation HOT_METLA_FLOW;

    @Override
    public void render(IMultiblockContext<ArcFurnaceLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ArcFurnaceLogic.State state = ctx.getState();
        Direction facing = ctx.getLevel().getOrientation().front();
        List renderedParts = null;
        for (int i = 0; i < 3; ++i) {
            if ((state.electrodePresence & 1 << i) == 0) continue;
            if (renderedParts == null) {
                renderedParts = Lists.newArrayList((Object[])new String[]{"electrode" + (i + 1)});
                continue;
            }
            renderedParts.add("electrode" + (i + 1));
        }
        if (renderedParts == null) {
            return;
        }
        if (state.isClientActive()) {
            renderedParts.add("active");
        }
        matrixStack.pushPose();
        List quads = ELECTRODES.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(renderedParts)), RenderType.cutout());
        matrixStack.pushPose();
        ArcFurnaceRenderer.rotateForFacing(matrixStack, facing);
        RenderUtils.renderModelTESRFast(quads, bufferIn.getBuffer(RenderType.solid()), matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.popPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        if (state.pouringMetal > 0) {
            if (this.hotMetal_flow == null) {
                TextureAtlas blockMap = ClientUtils.mc().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
                this.hotMetal_still = blockMap.getSprite(HOT_METLA_STILL);
                this.hotMetal_flow = blockMap.getSprite(HOT_METLA_FLOW);
            }
            ArcFurnaceRenderer.rotateForFacingNoCentering(matrixStack, facing);
            int process = 40;
            float speed = 5.0f;
            int pour = process - state.pouringMetal;
            float h = ((float)pour > (float)process - speed ? (float)(process - pour) / speed * 27.0f : ((float)pour > speed ? 27.0f : (float)pour / speed * 27.0f)) / 16.0f;
            matrixStack.translate(-0.5, 0.5625, 1.5);
            VertexConsumer fullbright = bufferIn.getBuffer(IERenderTypes.SOLID_FULLBRIGHT);
            matrixStack.pushPose();
            if ((float)pour > (float)process - speed) {
                matrixStack.translate(0.0f, -1.6875f + h, 0.0f);
            }
            if (h > 1.0f) {
                matrixStack.translate(0.0f, -h, 0.0f);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f, this.hotMetal_flow, true);
                matrixStack.translate(0.0f, 1.0f, 0.0f);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, h - 1.0f, 0.625f, this.hotMetal_flow, true);
                matrixStack.translate(0.0f, -1.0f, 0.0f);
                matrixStack.translate(0.0f, h, 0.0f);
            } else {
                matrixStack.translate(0.0f, -h, 0.0f);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, h, 0.625f, this.hotMetal_flow, true);
                matrixStack.translate(0.0f, h, 0.0f);
            }
            if ((float)pour > (float)process - speed) {
                matrixStack.translate(0.0f, 1.6875f - h, 0.0f);
            }
            if ((float)pour > speed) {
                float h2 = (float)pour > (float)process - speed ? 0.625f : (float)pour / ((float)process - speed) * 0.625f;
                matrixStack.translate(0.0f, -1.6875f, 0.0f);
                RenderUtils.renderTexturedBox(fullbright, matrixStack, 0.125f, 0.0f, 0.125f, 0.875f, h2, 0.875f, this.hotMetal_still, false);
                matrixStack.translate(0.0f, 1.6875f, 0.0f);
            }
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    static {
        HOT_METLA_STILL = new ResourceLocation("immersiveengineering", "block/fluid/hot_metal_still");
        HOT_METLA_FLOW = new ResourceLocation("immersiveengineering", "block/fluid/hot_metal_flow");
    }
}

