/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BlueprintRenderer {
    public static final RenderType RENDER_TYPE = IERenderTypes.POSITION_COLOR_LIGHTMAP;
    private static final HashMap<BlueprintCraftingRecipe, BlueprintLines> BLUEPRINT_CACHE = new HashMap();

    public static BlueprintLines getBlueprintDrawable(BlueprintCraftingRecipe recipe, Level world) {
        if (recipe == null) {
            return null;
        }
        BlueprintLines blueprint = BLUEPRINT_CACHE.get(recipe);
        if (blueprint == null) {
            blueprint = BlueprintRenderer.getBlueprintDrawable(recipe.output.get(), world);
            BLUEPRINT_CACHE.put(recipe, blueprint);
        }
        return blueprint;
    }

    public static BlueprintLines getBlueprintDrawable(ItemStack stack, Level world) {
        if (stack.isEmpty()) {
            return null;
        }
        LocalPlayer player = ClientUtils.mc().player;
        ArrayList<TextureAtlasSprite> images = new ArrayList<TextureAtlasSprite>();
        try {
            BakedModel ibakedmodel = ClientUtils.mc().getItemRenderer().getModel(stack, world, (LivingEntity)player, 0);
            HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
            List quads = ibakedmodel.getQuads(null, null, world.random, ModelData.EMPTY, null);
            Function blockAtlas = ClientUtils.mc().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS);
            for (BakedQuad quad : quads) {
                ResourceLocation texture = quad.getSprite().contents().name();
                if (!textures.add(texture)) continue;
                images.add((TextureAtlasSprite)blockAtlas.apply(texture));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (images.isEmpty()) {
            return null;
        }
        ArrayList lines = new ArrayList();
        HashSet<TexturePoint> testSet = new HashSet<TexturePoint>();
        HashMultimap area = HashMultimap.create();
        int wMax = 0;
        for (TextureAtlasSprite bufferedImage : images) {
            HashSet<Pair> tempLines = new HashSet<Pair>();
            int w = bufferedImage.contents().width();
            int h = bufferedImage.contents().height();
            if (h > w) {
                h = w;
            }
            if (w > wMax) {
                wMax = w;
            }
            for (int hh = 0; hh < h; ++hh) {
                for (int ww = 0; ww < w; ++ww) {
                    int argb = bufferedImage.getPixelRGBA(0, ww, hh);
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    float intesity = (r + b + g) / 3.0f;
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    boolean added = false;
                    TexturePoint tp = new TexturePoint(ww, hh, w);
                    if (!testSet.contains(tp)) {
                        for (Integer key : area.keySet()) {
                            for (TexturePoint p : area.get((Object)key)) {
                                float dB;
                                float dG;
                                float mod = (float)w / (float)p.scale;
                                int pColour = bufferedImage.getPixelRGBA(0, (int)((float)p.x * mod), (int)((float)p.y * mod));
                                float dR = r - (float)(pColour >> 16 & 0xFF) / 255.0f;
                                double delta = Math.sqrt(dR * dR + (dG = g - (float)(pColour >> 8 & 0xFF) / 255.0f) * dG + (dB = b - (float)(pColour & 0xFF) / 255.0f) * dB);
                                if (!(delta < 0.25)) continue;
                                area.put((Object)key, (Object)tp);
                                added = true;
                                break;
                            }
                            if (!added) continue;
                            break;
                        }
                        if (!added) {
                            area.put((Object)argb, (Object)tp);
                        }
                        testSet.add(tp);
                    }
                    for (int i = 0; i < 4; ++i) {
                        int xx;
                        int n = i == 0 ? -1 : (xx = i == 1 ? 1 : 0);
                        int yy = i == 2 ? -1 : (i == 3 ? 1 : 0);
                        int u = ww + xx;
                        int v = hh + yy;
                        int neighbour = 0;
                        float delta = 1.0f;
                        boolean notTransparent = false;
                        if (u >= 0 && u < w && v >= 0 && v < h) {
                            neighbour = bufferedImage.getPixelRGBA(0, u, v);
                            boolean bl = notTransparent = (neighbour >> 24 & 0xFF) > 0;
                            if (notTransparent) {
                                float bDelta;
                                float gDelta;
                                float rDelta;
                                float neighbourIntesity = (float)((neighbour >> 16 & 0xFF) + (neighbour >> 8 & 0xFF) + (neighbour & 0xFF)) / 765.0f;
                                float intesityDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(intesity - neighbourIntesity)));
                                delta = Math.max(intesityDelta, Math.max(rDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(r - (float)(neighbour >> 16 & 0xFF) / 255.0f))), Math.max(gDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(g - (float)(neighbour >> 8 & 0xFF) / 255.0f))), bDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(b - (float)(neighbour & 0xFF) / 255.0f))))));
                                float f = (double)delta < 0.25 ? 0.0f : (delta = (double)delta > 0.4 ? 1.0f : delta);
                            }
                        }
                        if (!(delta > 0.0f)) continue;
                        Pair l = Pair.of((Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 0)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 0)), w), (Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 1)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 1)), w));
                        tempLines.add(l);
                    }
                }
            }
            lines.addAll(tempLines);
        }
        ArrayList<Integer> lumiSort = new ArrayList<Integer>(area.keySet());
        lumiSort.sort(Comparator.comparingDouble(BlueprintRenderer::getLuminance));
        HashMultimap complete_areaMap = HashMultimap.create();
        int lineNumber = 2;
        StripeDirection lineStyle = StripeDirection.VERTICAL;
        for (Integer i : lumiSort) {
            Set styleSlot = complete_areaMap.get((Object)new ShadeStyle(lineNumber, lineStyle));
            for (TexturePoint point : area.get((Object)i)) {
                styleSlot.add(new Point(point.x(), point.y()));
            }
            if ((lineStyle = lineStyle.next()) != StripeDirection.VERTICAL) continue;
            ++lineNumber;
        }
        HashSet<Pair<Point, Point>> complete_lines = new HashSet<Pair<Point, Point>>();
        for (Pair line : lines) {
            TexturePoint p1 = (TexturePoint)line.getFirst();
            TexturePoint p2 = (TexturePoint)line.getSecond();
            complete_lines.add((Pair<Point, Point>)Pair.of((Object)new Point((int)((float)p1.x / (float)p1.scale * (float)wMax), (int)((float)p1.y / (float)p1.scale * (float)wMax)), (Object)new Point((int)((float)p2.x / (float)p2.scale * (float)wMax), (int)((float)p2.y / (float)p2.scale * (float)wMax))));
        }
        return new BlueprintLines(wMax, complete_lines, (HashMultimap<ShadeStyle, Point>)complete_areaMap);
    }

    private static void putLineVertex(PoseStack.Pose transform, VertexConsumer out, float x, float z, Vector3f normalUp, int light) {
        Vector4f position = new Vector4f(x, z, 0.0f, 1.0f);
        position.mul((Matrix4fc)transform.pose()).div(position.w);
        out.vertex(position.x(), position.y(), position.z(), 1.0f, 1.0f, 1.0f, 1.0f, 0.5f, 0.5f, OverlayTexture.NO_OVERLAY, light, normalUp.x(), normalUp.y(), normalUp.z());
    }

    private static LinePainter makeQuadLinePainter(PoseStack.Pose transform, VertexConsumer out, int light) {
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        up.mul((Matrix3fc)transform.normal());
        return (x0, y0, x1, y1, width) -> {
            float deltaX = x1 - x0;
            float deltaY = y1 - y0;
            double distance = Mth.invSqrt((float)(deltaY * deltaY + deltaX * deltaX));
            deltaX = (float)((double)deltaX / distance);
            deltaY = (float)((double)deltaY / distance);
            float offsetX = -deltaY * width;
            float offsetY = deltaX * width;
            BlueprintRenderer.putLineVertex(transform, out, x0 + offsetX, y0 + offsetY, up, light);
            BlueprintRenderer.putLineVertex(transform, out, x1 + offsetX, y1 + offsetY, up, light);
            BlueprintRenderer.putLineVertex(transform, out, x1 - offsetX, y1 - offsetY, up, light);
            BlueprintRenderer.putLineVertex(transform, out, x0 - offsetX, y0 - offsetY, up, light);
        };
    }

    private static double getLuminance(int rgb) {
        return Math.sqrt(0.241 * (double)(rgb >> 16 & 0xFF) + 0.691 * (double)(rgb >> 8 & 0xFF) + 0.068 * (double)(rgb & 0xFF));
    }

    public static class BlueprintLines {
        final int textureScale;
        final Set<Pair<Point, Point>> lines;
        final HashMultimap<ShadeStyle, Point> areas;

        BlueprintLines(int textureScale, Set<Pair<Point, Point>> lines, HashMultimap<ShadeStyle, Point> areas) {
            this.textureScale = textureScale;
            this.lines = lines;
            this.areas = areas;
        }

        public int getTextureScale() {
            return this.textureScale;
        }

        public void draw(PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
            this.draw(matrixStack, buffer.getBuffer(RENDER_TYPE), packedLight);
        }

        public void draw(PoseStack matrixStack, VertexConsumer baseBuilder, int packedLight) {
            LinePainter painter = BlueprintRenderer.makeQuadLinePainter(matrixStack.last(), baseBuilder, packedLight);
            for (Pair<Point, Point> line : this.lines) {
                painter.drawLine(((Point)line.getFirst()).x, ((Point)line.getFirst()).y, ((Point)line.getSecond()).x, ((Point)line.getSecond()).y, 0.2f);
            }
            for (ShadeStyle style : this.areas.keySet()) {
                for (Point pixel : this.areas.get((Object)style)) {
                    style.drawShading(pixel, painter);
                }
            }
        }
    }

    private record TexturePoint(int x, int y, int scale) {
    }

    private static enum StripeDirection {
        VERTICAL,
        HORIZONTAL,
        DIAGONAL;


        public StripeDirection next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case VERTICAL -> HORIZONTAL;
                case HORIZONTAL -> DIAGONAL;
                case DIAGONAL -> VERTICAL;
            };
        }
    }

    private record ShadeStyle(int stripeAmount, StripeDirection stripeDirection) {
        void drawShading(Point pixel, LinePainter painter) {
            float step = 1.0f / (float)this.stripeAmount;
            float offset = step / 2.0f;
            if (this.stripeDirection == StripeDirection.DIAGONAL) {
                int perSide = this.stripeAmount / 2 + this.stripeAmount % 2;
                step = 1.0f / (float)perSide;
                offset = this.stripeAmount % 2 == 0 ? step / 2.0f : step;
            }
            float width = 0.1f;
            block5: for (int i = 0; i < this.stripeAmount; ++i) {
                switch (this.stripeDirection) {
                    case VERTICAL: {
                        painter.drawLine((float)pixel.x + offset + step * (float)i, pixel.y, (float)pixel.x + offset + step * (float)i, pixel.y + 1, width);
                        continue block5;
                    }
                    case HORIZONTAL: {
                        painter.drawLine(pixel.x, (float)pixel.y + offset + step * (float)i, pixel.x + 1, (float)pixel.y + offset + step * (float)i, width);
                        continue block5;
                    }
                    case DIAGONAL: {
                        if (i == this.stripeAmount - 1 && this.stripeAmount % 2 == 1) {
                            painter.drawLine(pixel.x, pixel.y + 1, pixel.x + 1, pixel.y, width);
                            continue block5;
                        }
                        if (i % 2 == 0) {
                            painter.drawLine(pixel.x, (float)pixel.y + offset + step * (float)(i / 2), (float)pixel.x + offset + step * (float)(i / 2), pixel.y, width);
                            continue block5;
                        }
                        painter.drawLine((float)(pixel.x + 1) - offset - step * (float)(i / 2), pixel.y + 1, pixel.x + 1, (float)(pixel.y + 1) - offset - step * (float)(i / 2), width);
                    }
                }
            }
        }
    }

    private static interface LinePainter {
        public void drawLine(float var1, float var2, float var3, float var4, float var5);
    }
}

