/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.data.ModelData;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DynamicModel {
    private static final List<ResourceLocation> MODELS = new ArrayList<ResourceLocation>();
    private final ResourceLocation name;

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional ev) {
        for (ResourceLocation model : MODELS) {
            ev.register(model);
        }
    }

    public DynamicModel(String desc) {
        this.name = new ResourceLocation("immersiveengineering", "dynamic/" + desc);
        MODELS.add(this.name);
    }

    public BakedModel get() {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        return blockRenderer.getBlockModelShaper().getModelManager().getModel(this.name);
    }

    public List<BakedQuad> getNullQuads() {
        return this.getNullQuads(ModelData.EMPTY);
    }

    public List<BakedQuad> getNullQuads(ModelData data) {
        return this.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, data, null);
    }

    public ResourceLocation getName() {
        return this.name;
    }
}

