/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.NonNullSupplier;
import org.joml.Quaternionf;

public class WatermillRenderer
extends IEBlockEntityRenderer<WatermillBlockEntity> {
    public static final String NAME = "watermill";
    public static DynamicModel MODEL;
    private static final IVertexBufferHolder MODEL_BUFFER;

    public void render(WatermillBlockEntity tile, float partialTicks, PoseStack transform, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)tile.getLevelNonnull(), tile.getBlockPos())) {
            return;
        }
        transform.pushPose();
        transform.translate(0.5, 0.5, 0.5);
        if (tile.getFacing().getAxis() == Direction.Axis.X) {
            transform.mulPose(new Quaternionf().rotateY(1.5707964f));
        }
        float wheelRotation = (float)(6.2831854820251465 * (tile.getRotation() + (double)partialTicks * tile.getSpeed()));
        transform.mulPose(new Quaternionf().rotateZ(wheelRotation));
        transform.translate(-0.5, -0.5, -0.5);
        MODEL_BUFFER.render(RenderType.cutoutMipped(), combinedLightIn, combinedOverlayIn, bufferIn, transform);
        transform.popPose();
    }

    public static void reset() {
        MODEL_BUFFER.reset();
    }

    public AABB getRenderBoundingBox(WatermillBlockEntity watermill) {
        if (watermill.renderAABB == null) {
            BlockPos pos = watermill.getBlockPos();
            Direction facing = watermill.getFacing();
            watermill.renderAABB = watermill.offset[0] == 0 && watermill.offset[1] == 0 ? new AABB((double)(pos.getX() - (facing.getAxis() == Direction.Axis.Z ? 2 : 0)), (double)(pos.getY() - 2), (double)(pos.getZ() - (facing.getAxis() == Direction.Axis.Z ? 0 : 2)), (double)(pos.getX() + (facing.getAxis() == Direction.Axis.Z ? 3 : 1)), (double)(pos.getY() + 3), (double)(pos.getZ() + (facing.getAxis() == Direction.Axis.Z ? 1 : 3))) : new AABB(pos);
        }
        return watermill.renderAABB;
    }

    static {
        MODEL_BUFFER = IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> {
            BlockState state = (BlockState)IEBlocks.WoodenDevices.WATERMILL.defaultBlockState().setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)Direction.NORTH);
            return MODEL.get().getQuads(state, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        }));
    }
}

