/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class BakedQuadBuilder {
    public static final VertexFormat FORMAT = DefaultVertexFormat.BLOCK;
    private int nextVertex = 0;
    private int[] data = new int[FORMAT.getIntegerSize() * 4];

    public void putVertexData(Vec3 pos, Vec3 faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colour, float alpha) {
        this.putVertexData(pos, faceNormal, sprite.getU((float)(u / 16.0)), sprite.getV((float)(v / 16.0)), colour, alpha);
    }

    public void putVertexData(Vec3 pos, Vec3 faceNormal, double u, double v, float[] colour, float alpha) {
        int next = this.nextVertex * FORMAT.getIntegerSize();
        this.data[next++] = Float.floatToIntBits((float)pos.x);
        this.data[next++] = Float.floatToIntBits((float)pos.y);
        this.data[next++] = Float.floatToIntBits((float)pos.z);
        this.data[next++] = (int)(colour[0] * 255.0f) | (int)(colour[1] * 255.0f) << 8 | (int)(colour[2] * 255.0f) << 16 | (int)(colour[3] * alpha * 255.0f) << 24;
        this.data[next++] = Float.floatToIntBits((float)u);
        this.data[next++] = Float.floatToIntBits((float)v);
        this.data[next++] = 0;
        int n = next;
        this.data[n] = this.data[n] | (int)(faceNormal.x * 127.0) & 0xFF;
        int n2 = next;
        this.data[n2] = this.data[n2] | ((int)(faceNormal.y * 127.0) & 0xFF) << 8;
        int n3 = next++;
        this.data[n3] = this.data[n3] | ((int)(faceNormal.z * 127.0) & 0xFF) << 16;
        int extraPaddingBytes = 0;
        for (int i = 6; i < FORMAT.getElements().size(); ++i) {
            VertexFormatElement extraElement = (VertexFormatElement)FORMAT.getElements().get(i);
            Preconditions.checkState((extraElement.getUsage() == VertexFormatElement.Usage.PADDING ? 1 : 0) != 0);
            extraPaddingBytes += extraElement.getByteSize();
        }
        Preconditions.checkState((extraPaddingBytes % 4 == 0 ? 1 : 0) != 0);
        ++this.nextVertex;
        Preconditions.checkState(((next += extraPaddingBytes / 4) == this.nextVertex * FORMAT.getIntegerSize() ? 1 : 0) != 0);
    }

    public BakedQuad bake(int tint, Direction side, TextureAtlasSprite texture, boolean shade) {
        return new BakedQuad(this.data, tint, side, texture, shade);
    }
}

