/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.joml.Quaternionf;

public class BasicClientProperties
implements ClientMultiblocks.MultiblockManualData {
    private static final Map<ResourceLocation, DynamicModel> MODELS = new HashMap<ResourceLocation, DynamicModel>();
    private final IETemplateMultiblock multiblock;
    @Nullable
    private NonNullList<ItemStack> materials;
    private final Supplier<DynamicModel> model;
    private final Optional<Quaternionf> rotation;

    public BasicClientProperties(IETemplateMultiblock multiblock) {
        this(multiblock, OptionalDouble.empty());
    }

    public BasicClientProperties(IETemplateMultiblock multiblock, OptionalDouble yRotationRadians) {
        this.multiblock = multiblock;
        this.model = Suppliers.memoize(() -> MODELS.get(multiblock.getUniqueName()));
        this.rotation = yRotationRadians.stream().mapToObj(r -> new Quaternionf().rotateY((float)r)).findAny();
    }

    public static void initModels() {
        for (MultiblockHandler.IMultiblock mb : IEMultiblocks.IE_MULTIBLOCKS) {
            if (!(mb instanceof IETemplateMultiblock)) continue;
            IETemplateMultiblock ieMB = (IETemplateMultiblock)mb;
            MODELS.put(mb.getUniqueName(), new DynamicModel(ieMB.getBlockName().getPath()));
        }
    }

    @Override
    public NonNullList<ItemStack> getTotalMaterials() {
        if (this.materials == null) {
            List<StructureTemplate.StructureBlockInfo> structure = this.multiblock.getStructure((Level)Minecraft.getInstance().level);
            this.materials = NonNullList.create();
            for (StructureTemplate.StructureBlockInfo info : structure) {
                if (info.state().hasProperty((Property)IEProperties.MULTIBLOCKSLAVE) && ((Boolean)info.state().getValue((Property)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) continue;
                ItemStack picked = Utils.getPickBlock(info.state());
                boolean added = false;
                for (ItemStack existing : this.materials) {
                    if (!ItemStack.isSameItem((ItemStack)existing, (ItemStack)picked)) continue;
                    existing.grow(1);
                    added = true;
                    break;
                }
                if (added) continue;
                this.materials.add((Object)picked.copy());
            }
        }
        return this.materials;
    }

    @Override
    public void renderFormedStructure(PoseStack transform, MultiBufferSource bufferSource) {
        transform.pushPose();
        BlockPos offset = this.multiblock.getMasterFromOriginOffset();
        transform.translate((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
        if (this.rotation.isPresent()) {
            transform.translate(0.5, 0.0, 0.5);
            transform.mulPose(this.rotation.get());
            transform.translate(-0.5, 0.0, -0.5);
        }
        List<BakedQuad> nullQuads = this.model.get().getNullQuads();
        VertexConsumer buffer = bufferSource.getBuffer(IERenderTypes.TRANSLUCENT_FULLBRIGHT);
        nullQuads.forEach(quad -> buffer.putBulkData(transform.last(), quad, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY));
        transform.popPose();
    }

    @Override
    public boolean canRenderFormedStructure() {
        return true;
    }
}

