/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.client.utils.IEGLShaders;
import blusunrize.immersiveengineering.client.utils.WhiteTexture;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class IERenderTypes
extends RenderStateShard {
    public static final VertexFormat BLOCK_WITH_OVERLAY = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.ELEMENT_POSITION).put((Object)"Color", (Object)DefaultVertexFormat.ELEMENT_COLOR).put((Object)"UV0", (Object)DefaultVertexFormat.ELEMENT_UV0).put((Object)"UV1", (Object)DefaultVertexFormat.ELEMENT_UV1).put((Object)"UV2", (Object)DefaultVertexFormat.ELEMENT_UV2).put((Object)"Normal", (Object)DefaultVertexFormat.ELEMENT_NORMAL).put((Object)"Padding", (Object)DefaultVertexFormat.ELEMENT_PADDING).build());
    public static final RenderType TRANSLUCENT_FULLBRIGHT;
    public static final RenderType SOLID_FULLBRIGHT;
    public static final RenderType LINES;
    public static final RenderType LINES_NONTRANSLUCENT;
    public static final RenderType POINTS;
    public static final RenderType TRANSLUCENT_TRIANGLES;
    public static final RenderType TRANSLUCENT_POSITION_COLOR;
    public static final RenderType TRANSLUCENT_NO_DEPTH;
    public static final RenderType CHUNK_MARKER;
    public static final RenderType POSITION_COLOR_LIGHTMAP;
    public static final RenderType ITEM_DAMAGE_BAR;
    public static final RenderType PARTICLES;
    private static final Function<ResourceLocation, RenderType> GUI_CUTOUT;
    private static final Function<ResourceLocation, RenderType> GUI_TRANSLUCENT;
    private static final Function<ResourceLocation, RenderType> FULLBRIGHT_TRANSLUCENT;
    private static final RenderStateShard.ShaderStateShard RENDERTYPE_POSITION_COLOR;
    protected static final RenderStateShard.TextureStateShard BLOCK_SHEET_MIPPED;
    protected static final RenderStateShard.LightmapStateShard LIGHTMAP_DISABLED;
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY;
    protected static final RenderStateShard.ShaderStateShard FULLBRIGHT_BLOCKS;
    protected static final RenderStateShard.ShaderStateShard POINTS_SHADER;
    protected static final RenderStateShard.TransparencyStateShard NO_TRANSPARENCY;
    protected static final RenderStateShard.DepthTestStateShard DEPTH_ALWAYS;

    private IERenderTypes(String p_110161_, Runnable p_110162_, Runnable p_110163_) {
        super(p_110161_, p_110162_, p_110163_);
    }

    public static RenderType getGui(ResourceLocation texture) {
        return GUI_CUTOUT.apply(texture);
    }

    public static RenderType getGuiTranslucent(ResourceLocation texture) {
        return GUI_TRANSLUCENT.apply(texture);
    }

    private static RenderType.CompositeState.CompositeStateBuilder makeGuiState(ResourceLocation texture) {
        return RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setShaderState(POSITION_COLOR_TEX_SHADER);
    }

    public static RenderType getLines(float lineWidth) {
        return IERenderTypes.getLines(lineWidth, RenderStateShard.MAIN_TARGET);
    }

    public static RenderType getParticleLines(float lineWidth) {
        return IERenderTypes.getLines(lineWidth, RenderStateShard.PARTICLES_TARGET);
    }

    private static RenderType getLines(float lineWidth, RenderStateShard.OutputStateShard target) {
        return IERenderTypes.createDefault("lines_color_pos_" + lineWidth, DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, RenderType.CompositeState.builder().setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(lineWidth))).setShaderState(RENDERTYPE_LINES_SHADER).setOutputState(target).createCompositeState(false));
    }

    public static RenderType getPositionTex(ResourceLocation texture) {
        return IERenderTypes.createDefault("immersiveengineering:pos_tex_" + texture, DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setShaderState(POSITION_TEX_SHADER).createCompositeState(false));
    }

    private static RenderType createDefault(String name, VertexFormat format, VertexFormat.Mode mode, RenderType.CompositeState state) {
        return RenderType.create((String)name, (VertexFormat)format, (VertexFormat.Mode)mode, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getFullbrightTranslucent(ResourceLocation texture) {
        return FULLBRIGHT_TRANSLUCENT.apply(texture);
    }

    public static MultiBufferSource wrapWithStencil(MultiBufferSource in, Consumer<VertexConsumer> setupStencilArea, String name, int ref) {
        return IERenderTypes.wrapWithAdditional(in, "stencil_" + name + "_" + ref, () -> {
            GL11.glEnable((int)2960);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.depthMask((boolean)false);
            GL11.glStencilFunc((int)512, (int)1, (int)255);
            GL11.glStencilOp((int)7681, (int)7680, (int)7680);
            GL11.glStencilMask((int)255);
            RenderSystem.clear((int)1024, (boolean)true);
            Tesselator tes = Tesselator.getInstance();
            BufferBuilder bb = tes.getBuilder();
            bb.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            setupStencilArea.accept((VertexConsumer)bb);
            tes.end();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.depthMask((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)ref, (int)255);
        }, () -> GL11.glDisable((int)2960));
    }

    public static MultiBufferSource whiteLightmap(MultiBufferSource in) {
        return IERenderTypes.wrapWithAdditional(in, "white_light", () -> WhiteTexture.INSTANCE.get().bind(), () -> Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer());
    }

    private static MultiBufferSource wrapWithAdditional(MultiBufferSource in, String name, Runnable setup, Runnable teardown) {
        return type -> in.getBuffer(new RenderType("immersiveengineering:" + type + "_" + name, type.format(), type.mode(), type.bufferSize(), type.affectsCrumbling(), false, () -> {
            type.setupRenderState();
            setup.run();
        }, () -> {
            teardown.run();
            type.clearRenderState();
        }){});
    }

    static {
        RENDERTYPE_POSITION_COLOR = RENDERTYPE_LIGHTNING_SHADER;
        BLOCK_SHEET_MIPPED = new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_BLOCKS, false, true);
        LIGHTMAP_DISABLED = new RenderStateShard.LightmapStateShard(false);
        TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }, RenderSystem::disableBlend);
        FULLBRIGHT_BLOCKS = new RenderStateShard.ShaderStateShard(IEGLShaders::getBlockFullbrightShader);
        POINTS_SHADER = new RenderStateShard.ShaderStateShard(IEGLShaders::getPointShader);
        NO_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("no_transparency", RenderSystem::disableBlend, () -> {});
        DEPTH_ALWAYS = new RenderStateShard.DepthTestStateShard("always", 519);
        SOLID_FULLBRIGHT = IERenderTypes.createDefault("immersiveengineering:solid_fullbright", BLOCK_WITH_OVERLAY, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setShaderState(FULLBRIGHT_BLOCKS).setOverlayState(OVERLAY).setLightmapState(LIGHTMAP_DISABLED).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).createCompositeState(false));
        TRANSLUCENT_FULLBRIGHT = IERenderTypes.createDefault("immersiveengineering:translucent_fullbright", BLOCK_WITH_OVERLAY, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setShaderState(FULLBRIGHT_BLOCKS).setLightmapState(LIGHTMAP_DISABLED).setOverlayState(OVERLAY).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setTransparencyState(TRANSLUCENT_TRANSPARENCY).createCompositeState(false));
        RenderType.CompositeState translucentNoDepthState = RenderType.CompositeState.builder().setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).setDepthTestState(DEPTH_ALWAYS).setShaderState(RENDERTYPE_POSITION_COLOR).createCompositeState(false);
        LINES = IERenderTypes.createDefault("immersiveengineering:translucent_lines", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));
        LINES_NONTRANSLUCENT = IERenderTypes.createDefault("immersiveengineering:nontranslucent_lines", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(NO_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));
        POINTS = IERenderTypes.createDefault("immersiveengineering:points", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setShaderState(POINTS_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.PARTICLES_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));
        TRANSLUCENT_TRIANGLES = IERenderTypes.createDefault("immersiveengineering:translucent_triangles", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES, translucentNoDepthState);
        RenderType.CompositeState translucentNoTextureState = RenderType.CompositeState.builder().setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setShaderState(RENDERTYPE_POSITION_COLOR).createCompositeState(false);
        TRANSLUCENT_POSITION_COLOR = IERenderTypes.createDefault("immersiveengineering:translucent_pos_color", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, translucentNoTextureState);
        TRANSLUCENT_NO_DEPTH = IERenderTypes.createDefault("immersiveengineering:translucent_no_depth", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, translucentNoDepthState);
        CHUNK_MARKER = IERenderTypes.createDefault("immersiveengineering:chunk_marker", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, RenderType.CompositeState.builder().setTransparencyState(TRANSLUCENT_TRANSPARENCY).setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(5.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setCullState(NO_CULL).setOutputState(MAIN_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).createCompositeState(false));
        POSITION_COLOR_LIGHTMAP = IERenderTypes.createDefault("immersiveengineering:pos_color_lightmap", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setLightmapState(new RenderStateShard.LightmapStateShard(true)).setTextureState((RenderStateShard.EmptyTextureStateShard)new WhiteTextureStateShard()).setShaderState(POSITION_COLOR_LIGHTMAP_SHADER).createCompositeState(false));
        ITEM_DAMAGE_BAR = IERenderTypes.createDefault("immersiveengineering:item_damage_bar", DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setDepthTestState(DEPTH_ALWAYS).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setShaderState(POSITION_COLOR_SHADER).setTransparencyState(NO_TRANSPARENCY).createCompositeState(false));
        PARTICLES = IERenderTypes.createDefault("immersiveengineering:particles", DefaultVertexFormat.PARTICLE, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false)).setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getParticleShader)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).createCompositeState(true));
        GUI_CUTOUT = Util.memoize(texture -> IERenderTypes.createDefault("gui_" + texture, DefaultVertexFormat.POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, IERenderTypes.makeGuiState(texture).createCompositeState(false)));
        GUI_TRANSLUCENT = Util.memoize(texture -> IERenderTypes.createDefault("gui_translucent_" + texture, DefaultVertexFormat.POSITION_COLOR_TEX, VertexFormat.Mode.QUADS, IERenderTypes.makeGuiState(texture).setTransparencyState(TRANSLUCENT_TRANSPARENCY).createCompositeState(false)));
        FULLBRIGHT_TRANSLUCENT = Util.memoize(texture -> IERenderTypes.createDefault("immersiveengineering:fullbright_translucent_" + texture, DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RenderType.CompositeState.builder().setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setLightmapState(LIGHTMAP_DISABLED).setShaderState(FULLBRIGHT_BLOCKS).setCullState(NO_CULL).setOverlayState(OVERLAY).createCompositeState(true)));
    }

    private static class WhiteTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        public WhiteTextureStateShard() {
            super(() -> RenderSystem.setShaderTexture((int)0, (ResourceLocation)WhiteTexture.INSTANCE.get().getTextureLocation()), () -> {});
        }

        @Nonnull
        public String toString() {
            return "IE: White";
        }

        @Nonnull
        protected Optional<ResourceLocation> cutoutTexture() {
            return Optional.of(WhiteTexture.INSTANCE.get().getTextureLocation());
        }
    }
}

